<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Sets the ApiAuthentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ApiAuthentication $apiAuthentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderApiAuthentication(\StructType\ApiAuthentication $apiAuthentication, $nameSpace = 'http://api.exigo.com/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ApiAuthentication', $apiAuthentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named DeleteCalendarItem
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Deletes a calendar item.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteCalendarItemRequest $deleteCalendarItemRequest
     * @return \StructType\DeleteCalendarItemResponse|bool
     */
    public function DeleteCalendarItem(\StructType\DeleteCalendarItemRequest $deleteCalendarItemRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteCalendarItem($deleteCalendarItemRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteCustomerContact
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Deletes a customer contact.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteCustomerContactRequest $deleteCustomerContactRequest
     * @return \StructType\DeleteCustomerContactResponse|bool
     */
    public function DeleteCustomerContact(\StructType\DeleteCustomerContactRequest $deleteCustomerContactRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteCustomerContact($deleteCustomerContactRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteCustomerExtended
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Removes one customer extended record.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteCustomerExtendedRequest $deleteCustomerExtendedRequest
     * @return \StructType\DeleteCustomerExtendedResponse|bool
     */
    public function DeleteCustomerExtended(\StructType\DeleteCustomerExtendedRequest $deleteCustomerExtendedRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteCustomerExtended($deleteCustomerExtendedRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteCustomerLead
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Deletes a customer lead.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteCustomerLeadRequest $deleteCustomerLeadRequest
     * @return \StructType\DeleteCustomerLeadResponse|bool
     */
    public function DeleteCustomerLead(\StructType\DeleteCustomerLeadRequest $deleteCustomerLeadRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteCustomerLead($deleteCustomerLeadRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteCustomerWallItem
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Delete wall item(s) from CustomerWall table.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteCustomerWallItemRequest $deleteCustomerWallItemRequest
     * @return \StructType\DeleteCustomerWallItemResponse|bool
     */
    public function DeleteCustomerWallItem(\StructType\DeleteCustomerWallItemRequest $deleteCustomerWallItemRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteCustomerWallItem($deleteCustomerWallItemRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteEmail
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Deletes an email forever.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteEmailRequest $deleteEmailRequest
     * @return \StructType\DeleteEmailResponse|bool
     */
    public function DeleteEmail(\StructType\DeleteEmailRequest $deleteEmailRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteEmail($deleteEmailRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteEmailTemplate
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Deletes an email template.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteEmailTemplateRequest $deleteEmailTemplateRequest
     * @return \StructType\DeleteEmailTemplateResponse|bool
     */
    public function DeleteEmailTemplate(\StructType\DeleteEmailTemplateRequest $deleteEmailTemplateRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteEmailTemplate($deleteEmailTemplateRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteExtendedDbEntity
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Delete Extended DB Entity.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteEntityRequest $deleteEntityRequest
     * @return \StructType\DeleteEntityResponse|bool
     */
    public function DeleteExtendedDbEntity(\StructType\DeleteEntityRequest $deleteEntityRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteExtendedDbEntity($deleteEntityRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteExtendedDbSchema
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Delete Extended DB schema.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteSchemaRequest $deleteSchemaRequest
     * @return \StructType\DeleteSchemaResponse|bool
     */
    public function DeleteExtendedDbSchema(\StructType\DeleteSchemaRequest $deleteSchemaRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteExtendedDbSchema($deleteSchemaRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteMailFolder
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Deletes a mail folder.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteMailFolderRequest $deleteMailFolderRequest
     * @return \StructType\DeleteMailFolderResponse|bool
     */
    public function DeleteMailFolder(\StructType\DeleteMailFolderRequest $deleteMailFolderRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteMailFolder($deleteMailFolderRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteOrderDetail
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Delete an existing Order Detail for an existing order without recalculating. Can participate in a transaction.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteOrderDetailRequest $deleteOrderDetailRequest
     * @return \StructType\DeleteOrderDetailResponse|bool
     */
    public function DeleteOrderDetail(\StructType\DeleteOrderDetailRequest $deleteOrderDetailRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteOrderDetail($deleteOrderDetailRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteProductFromCategory
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Deletes a product from a web category.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteProductFromCategoryRequest $deleteProductFromCategoryRequest
     * @return \StructType\DeleteProductFromCategoryResponse|bool
     */
    public function DeleteProductFromCategory(\StructType\DeleteProductFromCategoryRequest $deleteProductFromCategoryRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteProductFromCategory($deleteProductFromCategoryRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteQualificationOverride
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Delete a Customer Override
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteQualificationOverrideRequest $deleteQualificationOverrideRequest
     * @return \StructType\DeleteQualificationOverrideResponse|bool
     */
    public function DeleteQualificationOverride(\StructType\DeleteQualificationOverrideRequest $deleteQualificationOverrideRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteQualificationOverride($deleteQualificationOverrideRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteWebCategory
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Deletes a web category.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteWebCategoryRequest $deleteWebCategoryRequest
     * @return \StructType\DeleteWebCategoryResponse|bool
     */
    public function DeleteWebCategory(\StructType\DeleteWebCategoryRequest $deleteWebCategoryRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteWebCategory($deleteWebCategoryRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DeleteCalendarItemResponse|\StructType\DeleteCustomerContactResponse|\StructType\DeleteCustomerExtendedResponse|\StructType\DeleteCustomerLeadResponse|\StructType\DeleteCustomerWallItemResponse|\StructType\DeleteEmailResponse|\StructType\DeleteEmailTemplateResponse|\StructType\DeleteEntityResponse|\StructType\DeleteMailFolderResponse|\StructType\DeleteOrderDetailResponse|\StructType\DeleteProductFromCategoryResponse|\StructType\DeleteQualificationOverrideResponse|\StructType\DeleteSchemaResponse|\StructType\DeleteWebCategoryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
