<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Charge ServiceType
 * @subpackage Services
 */
class Charge extends AbstractSoapClientBase
{
    /**
     * Sets the ApiAuthentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ApiAuthentication $apiAuthentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderApiAuthentication(\StructType\ApiAuthentication $apiAuthentication, $nameSpace = 'http://api.exigo.com/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ApiAuthentication', $apiAuthentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ChargeCreditCard
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Deprecated. Use ChargeCreditCardToken instead.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ChargeCreditCardRequest $chargeCreditCardRequest
     * @return \StructType\ChargeCreditCardResponse|bool
     */
    public function ChargeCreditCard(\StructType\ChargeCreditCardRequest $chargeCreditCardRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->ChargeCreditCard($chargeCreditCardRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ChargeCreditCardOnFile
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Deprecated. Use ChargeCreditCardTokenOnFile instead.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ChargeCreditCardOnFileRequest $chargeCreditCardOnFileRequest
     * @return \StructType\ChargeCreditCardResponse|bool
     */
    public function ChargeCreditCardOnFile(\StructType\ChargeCreditCardOnFileRequest $chargeCreditCardOnFileRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->ChargeCreditCardOnFile($chargeCreditCardOnFileRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ChargeCreditCardToken
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Attempts to charge a card token with the amount found on an exiting order, or a new order in a transaction.If the charge is successful, the order is changed to accepted.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ChargeCreditCardTokenRequest $chargeCreditCardTokenRequest
     * @return \StructType\ChargeCreditCardResponse|bool
     */
    public function ChargeCreditCardToken(\StructType\ChargeCreditCardTokenRequest $chargeCreditCardTokenRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->ChargeCreditCardToken($chargeCreditCardTokenRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ChargeCreditCardTokenOnFile
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Attempts to charge a card token on file with the amount found on an exiting order, or a new order in a transaction. If the charge is successful, the order is changed to accepted.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ChargeCreditCardTokenOnFileRequest $chargeCreditCardTokenOnFileRequest
     * @return \StructType\ChargeCreditCardResponse|bool
     */
    public function ChargeCreditCardTokenOnFile(\StructType\ChargeCreditCardTokenOnFileRequest $chargeCreditCardTokenOnFileRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->ChargeCreditCardTokenOnFile($chargeCreditCardTokenOnFileRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ChargeGroupOrderCreditCardToken
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Attempts to charge a card token with the amount found on the specified orders.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ChargeGroupOrderCreditCardTokenRequest $chargeGroupOrderCreditCardTokenRequest
     * @return \StructType\ChargeGroupOrderCreditCardTokenResponse|bool
     */
    public function ChargeGroupOrderCreditCardToken(\StructType\ChargeGroupOrderCreditCardTokenRequest $chargeGroupOrderCreditCardTokenRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->ChargeGroupOrderCreditCardToken($chargeGroupOrderCreditCardTokenRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ChargePriorAuthorization
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Attempts to charge a prior authorization with the amount found on an existing order, or a new order in a transaction. If the charge is successful, the order is changed to accepted.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ChargePriorAuthorizationRequest $chargePriorAuthorizationRequest
     * @return \StructType\ChargeCreditCardResponse|bool
     */
    public function ChargePriorAuthorization(\StructType\ChargePriorAuthorizationRequest $chargePriorAuthorizationRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->ChargePriorAuthorization($chargePriorAuthorizationRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ChargeWalletAccount
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Attempts to debit a wallet account with the amount found on an exiting order, or a new order in a transaction. If the debit request is successful, the order is changed to accepted.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ChargeWalletAccountRequest $chargeWalletAccountRequest
     * @return \StructType\ChargeWalletAccountResponse|bool
     */
    public function ChargeWalletAccount(\StructType\ChargeWalletAccountRequest $chargeWalletAccountRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->ChargeWalletAccount($chargeWalletAccountRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ChargeWalletAccountOnFile
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Attempts to debit a wallet account with the amount found on an exiting order, or a new order in a transaction. If the debit request is successful, the order is changed to accepted.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ChargeWalletAccountOnFileRequest $chargeWalletAccountOnFileRequest
     * @return \StructType\ChargeWalletAccountResponse|bool
     */
    public function ChargeWalletAccountOnFile(\StructType\ChargeWalletAccountOnFileRequest $chargeWalletAccountOnFileRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->ChargeWalletAccountOnFile($chargeWalletAccountOnFileRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ChargeCreditCardResponse|\StructType\ChargeGroupOrderCreditCardTokenResponse|\StructType\ChargeWalletAccountResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
