<?php

namespace EnumType;

/**
 * This class stands for PropertyType EnumType
 * @subpackage Enumerations
 */
class PropertyType
{
    /**
     * Constant for value 'Integer'
     * @return string 'Integer'
     */
    const VALUE_INTEGER = 'Integer';
    /**
     * Constant for value 'DateTime'
     * @return string 'DateTime'
     */
    const VALUE_DATE_TIME = 'DateTime';
    /**
     * Constant for value 'Decimal'
     * @return string 'Decimal'
     */
    const VALUE_DECIMAL = 'Decimal';
    /**
     * Constant for value 'Boolean'
     * @return string 'Boolean'
     */
    const VALUE_BOOLEAN = 'Boolean';
    /**
     * Constant for value 'String'
     * @return string 'String'
     */
    const VALUE_STRING = 'String';
    /**
     * Constant for value 'Binary'
     * @return string 'Binary'
     */
    const VALUE_BINARY = 'Binary';
    /**
     * Constant for value 'Guid'
     * @return string 'Guid'
     */
    const VALUE_GUID = 'Guid';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INTEGER
     * @uses self::VALUE_DATE_TIME
     * @uses self::VALUE_DECIMAL
     * @uses self::VALUE_BOOLEAN
     * @uses self::VALUE_STRING
     * @uses self::VALUE_BINARY
     * @uses self::VALUE_GUID
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INTEGER,
            self::VALUE_DATE_TIME,
            self::VALUE_DECIMAL,
            self::VALUE_BOOLEAN,
            self::VALUE_STRING,
            self::VALUE_BINARY,
            self::VALUE_GUID,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
