<?php

namespace EnumType;

/**
 * This class stands for OrderStatusType EnumType
 * @subpackage Enumerations
 */
class OrderStatusType
{
    /**
     * Constant for value 'Incomplete'
     * @return string 'Incomplete'
     */
    const VALUE_INCOMPLETE = 'Incomplete';
    /**
     * Constant for value 'Pending'
     * @return string 'Pending'
     */
    const VALUE_PENDING = 'Pending';
    /**
     * Constant for value 'CCDeclined'
     * @return string 'CCDeclined'
     */
    const VALUE_CCDECLINED = 'CCDeclined';
    /**
     * Constant for value 'ACHDeclined'
     * @return string 'ACHDeclined'
     */
    const VALUE_ACHDECLINED = 'ACHDeclined';
    /**
     * Constant for value 'Canceled'
     * @return string 'Canceled'
     */
    const VALUE_CANCELED = 'Canceled';
    /**
     * Constant for value 'CCPending'
     * @return string 'CCPending'
     */
    const VALUE_CCPENDING = 'CCPending';
    /**
     * Constant for value 'ACHPending'
     * @return string 'ACHPending'
     */
    const VALUE_ACHPENDING = 'ACHPending';
    /**
     * Constant for value 'Accepted'
     * @return string 'Accepted'
     */
    const VALUE_ACCEPTED = 'Accepted';
    /**
     * Constant for value 'Printed'
     * @return string 'Printed'
     */
    const VALUE_PRINTED = 'Printed';
    /**
     * Constant for value 'Shipped'
     * @return string 'Shipped'
     */
    const VALUE_SHIPPED = 'Shipped';
    /**
     * Constant for value 'PendingInventory'
     * @return string 'PendingInventory'
     */
    const VALUE_PENDING_INVENTORY = 'PendingInventory';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INCOMPLETE
     * @uses self::VALUE_PENDING
     * @uses self::VALUE_CCDECLINED
     * @uses self::VALUE_ACHDECLINED
     * @uses self::VALUE_CANCELED
     * @uses self::VALUE_CCPENDING
     * @uses self::VALUE_ACHPENDING
     * @uses self::VALUE_ACCEPTED
     * @uses self::VALUE_PRINTED
     * @uses self::VALUE_SHIPPED
     * @uses self::VALUE_PENDING_INVENTORY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INCOMPLETE,
            self::VALUE_PENDING,
            self::VALUE_CCDECLINED,
            self::VALUE_ACHDECLINED,
            self::VALUE_CANCELED,
            self::VALUE_CCPENDING,
            self::VALUE_ACHPENDING,
            self::VALUE_ACCEPTED,
            self::VALUE_PRINTED,
            self::VALUE_SHIPPED,
            self::VALUE_PENDING_INVENTORY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
