<?php

namespace EnumType;

/**
 * This class stands for MailStatusType EnumType
 * @subpackage Enumerations
 */
class MailStatusType
{
    /**
     * Constant for value 'New'
     * @return string 'New'
     */
    const VALUE_NEW = 'New';
    /**
     * Constant for value 'Read'
     * @return string 'Read'
     */
    const VALUE_READ = 'Read';
    /**
     * Constant for value 'Forwarded'
     * @return string 'Forwarded'
     */
    const VALUE_FORWARDED = 'Forwarded';
    /**
     * Constant for value 'Replied'
     * @return string 'Replied'
     */
    const VALUE_REPLIED = 'Replied';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NEW
     * @uses self::VALUE_READ
     * @uses self::VALUE_FORWARDED
     * @uses self::VALUE_REPLIED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NEW,
            self::VALUE_READ,
            self::VALUE_FORWARDED,
            self::VALUE_REPLIED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
