<?php

namespace EnumType;

/**
 * This class stands for MailForderType EnumType
 * @subpackage Enumerations
 */
class MailForderType
{
    /**
     * Constant for value 'SubFolder'
     * @return string 'SubFolder'
     */
    const VALUE_SUB_FOLDER = 'SubFolder';
    /**
     * Constant for value 'Inbox'
     * @return string 'Inbox'
     */
    const VALUE_INBOX = 'Inbox';
    /**
     * Constant for value 'SentItems'
     * @return string 'SentItems'
     */
    const VALUE_SENT_ITEMS = 'SentItems';
    /**
     * Constant for value 'Drafts'
     * @return string 'Drafts'
     */
    const VALUE_DRAFTS = 'Drafts';
    /**
     * Constant for value 'DeletedItems'
     * @return string 'DeletedItems'
     */
    const VALUE_DELETED_ITEMS = 'DeletedItems';
    /**
     * Constant for value 'JunkMail'
     * @return string 'JunkMail'
     */
    const VALUE_JUNK_MAIL = 'JunkMail';
    /**
     * Constant for value 'FaxInbox'
     * @return string 'FaxInbox'
     */
    const VALUE_FAX_INBOX = 'FaxInbox';
    /**
     * Constant for value 'SentFaxes'
     * @return string 'SentFaxes'
     */
    const VALUE_SENT_FAXES = 'SentFaxes';
    /**
     * Constant for value 'PersonalFolders'
     * @return string 'PersonalFolders'
     */
    const VALUE_PERSONAL_FOLDERS = 'PersonalFolders';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SUB_FOLDER
     * @uses self::VALUE_INBOX
     * @uses self::VALUE_SENT_ITEMS
     * @uses self::VALUE_DRAFTS
     * @uses self::VALUE_DELETED_ITEMS
     * @uses self::VALUE_JUNK_MAIL
     * @uses self::VALUE_FAX_INBOX
     * @uses self::VALUE_SENT_FAXES
     * @uses self::VALUE_PERSONAL_FOLDERS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SUB_FOLDER,
            self::VALUE_INBOX,
            self::VALUE_SENT_ITEMS,
            self::VALUE_DRAFTS,
            self::VALUE_DELETED_ITEMS,
            self::VALUE_JUNK_MAIL,
            self::VALUE_FAX_INBOX,
            self::VALUE_SENT_FAXES,
            self::VALUE_PERSONAL_FOLDERS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
