<?php

namespace EnumType;

/**
 * This class stands for ContactPhoneType EnumType
 * @subpackage Enumerations
 */
class ContactPhoneType
{
    /**
     * Constant for value 'Office'
     * @return string 'Office'
     */
    const VALUE_OFFICE = 'Office';
    /**
     * Constant for value 'Mobile'
     * @return string 'Mobile'
     */
    const VALUE_MOBILE = 'Mobile';
    /**
     * Constant for value 'Home'
     * @return string 'Home'
     */
    const VALUE_HOME = 'Home';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OFFICE
     * @uses self::VALUE_MOBILE
     * @uses self::VALUE_HOME
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OFFICE,
            self::VALUE_MOBILE,
            self::VALUE_HOME,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
