<?php

namespace EnumType;

/**
 * This class stands for CalendarItemType EnumType
 * @subpackage Enumerations
 */
class CalendarItemType
{
    /**
     * Constant for value 'Appointment'
     * @return string 'Appointment'
     */
    const VALUE_APPOINTMENT = 'Appointment';
    /**
     * Constant for value 'ToDo'
     * @return string 'ToDo'
     */
    const VALUE_TO_DO = 'ToDo';
    /**
     * Constant for value 'Anniversary'
     * @return string 'Anniversary'
     */
    const VALUE_ANNIVERSARY = 'Anniversary';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_APPOINTMENT
     * @uses self::VALUE_TO_DO
     * @uses self::VALUE_ANNIVERSARY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_APPOINTMENT,
            self::VALUE_TO_DO,
            self::VALUE_ANNIVERSARY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
