<?php

namespace EnumType;

/**
 * This class stands for BankAccountType EnumType
 * @subpackage Enumerations
 */
class BankAccountType
{
    /**
     * Constant for value 'CheckingPersonal'
     * @return string 'CheckingPersonal'
     */
    const VALUE_CHECKING_PERSONAL = 'CheckingPersonal';
    /**
     * Constant for value 'CheckingBusiness'
     * @return string 'CheckingBusiness'
     */
    const VALUE_CHECKING_BUSINESS = 'CheckingBusiness';
    /**
     * Constant for value 'SavingsPersonal'
     * @return string 'SavingsPersonal'
     */
    const VALUE_SAVINGS_PERSONAL = 'SavingsPersonal';
    /**
     * Constant for value 'SavingsBusiness'
     * @return string 'SavingsBusiness'
     */
    const VALUE_SAVINGS_BUSINESS = 'SavingsBusiness';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CHECKING_PERSONAL
     * @uses self::VALUE_CHECKING_BUSINESS
     * @uses self::VALUE_SAVINGS_PERSONAL
     * @uses self::VALUE_SAVINGS_BUSINESS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CHECKING_PERSONAL,
            self::VALUE_CHECKING_BUSINESS,
            self::VALUE_SAVINGS_PERSONAL,
            self::VALUE_SAVINGS_BUSINESS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
