<?php

namespace EnumType;

/**
 * This class stands for AutoOrderProcessType EnumType
 * @subpackage Enumerations
 */
class AutoOrderProcessType
{
    /**
     * Constant for value 'AlwaysProcess'
     * @return string 'AlwaysProcess'
     */
    const VALUE_ALWAYS_PROCESS = 'AlwaysProcess';
    /**
     * Constant for value 'Conditional'
     * @return string 'Conditional'
     */
    const VALUE_CONDITIONAL = 'Conditional';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALWAYS_PROCESS
     * @uses self::VALUE_CONDITIONAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALWAYS_PROCESS,
            self::VALUE_CONDITIONAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
