<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfShipMethodResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfShipMethodResponse extends AbstractStructArrayBase
{
    /**
     * The ShipMethodResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ShipMethodResponse[]
     */
    public $ShipMethodResponse;
    /**
     * Constructor method for ArrayOfShipMethodResponse
     * @uses ArrayOfShipMethodResponse::setShipMethodResponse()
     * @param \StructType\ShipMethodResponse[] $shipMethodResponse
     */
    public function __construct(array $shipMethodResponse = array())
    {
        $this
            ->setShipMethodResponse($shipMethodResponse);
    }
    /**
     * Get ShipMethodResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ShipMethodResponse[]|null
     */
    public function getShipMethodResponse()
    {
        return isset($this->ShipMethodResponse) ? $this->ShipMethodResponse : null;
    }
    /**
     * Set ShipMethodResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ShipMethodResponse[] $shipMethodResponse
     * @return \ArrayType\ArrayOfShipMethodResponse
     */
    public function setShipMethodResponse(array $shipMethodResponse = array())
    {
        foreach ($shipMethodResponse as $arrayOfShipMethodResponseShipMethodResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfShipMethodResponseShipMethodResponseItem instanceof \StructType\ShipMethodResponse) {
                throw new \InvalidArgumentException(sprintf('The ShipMethodResponse property can only contain items of \StructType\ShipMethodResponse, "%s" given', is_object($arrayOfShipMethodResponseShipMethodResponseItem) ? get_class($arrayOfShipMethodResponseShipMethodResponseItem) : gettype($arrayOfShipMethodResponseShipMethodResponseItem)), __LINE__);
            }
        }
        if (is_null($shipMethodResponse) || (is_array($shipMethodResponse) && empty($shipMethodResponse))) {
            unset($this->ShipMethodResponse);
        } else {
            $this->ShipMethodResponse = $shipMethodResponse;
        }
        return $this;
    }
    /**
     * Add item to ShipMethodResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\ShipMethodResponse $item
     * @return \ArrayType\ArrayOfShipMethodResponse
     */
    public function addToShipMethodResponse(\StructType\ShipMethodResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShipMethodResponse) {
            throw new \InvalidArgumentException(sprintf('The ShipMethodResponse property can only contain items of \StructType\ShipMethodResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ShipMethodResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ShipMethodResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ShipMethodResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ShipMethodResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ShipMethodResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ShipMethodResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ShipMethodResponse
     */
    public function getAttributeName()
    {
        return 'ShipMethodResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfShipMethodResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
