<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSandbox ArrayType
 * @subpackage Arrays
 */
class ArrayOfSandbox extends AbstractStructArrayBase
{
    /**
     * The Sandbox
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Sandbox[]
     */
    public $Sandbox;
    /**
     * Constructor method for ArrayOfSandbox
     * @uses ArrayOfSandbox::setSandbox()
     * @param \StructType\Sandbox[] $sandbox
     */
    public function __construct(array $sandbox = array())
    {
        $this
            ->setSandbox($sandbox);
    }
    /**
     * Get Sandbox value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Sandbox[]|null
     */
    public function getSandbox()
    {
        return isset($this->Sandbox) ? $this->Sandbox : null;
    }
    /**
     * Set Sandbox value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Sandbox[] $sandbox
     * @return \ArrayType\ArrayOfSandbox
     */
    public function setSandbox(array $sandbox = array())
    {
        foreach ($sandbox as $arrayOfSandboxSandboxItem) {
            // validation for constraint: itemType
            if (!$arrayOfSandboxSandboxItem instanceof \StructType\Sandbox) {
                throw new \InvalidArgumentException(sprintf('The Sandbox property can only contain items of \StructType\Sandbox, "%s" given', is_object($arrayOfSandboxSandboxItem) ? get_class($arrayOfSandboxSandboxItem) : gettype($arrayOfSandboxSandboxItem)), __LINE__);
            }
        }
        if (is_null($sandbox) || (is_array($sandbox) && empty($sandbox))) {
            unset($this->Sandbox);
        } else {
            $this->Sandbox = $sandbox;
        }
        return $this;
    }
    /**
     * Add item to Sandbox value
     * @throws \InvalidArgumentException
     * @param \StructType\Sandbox $item
     * @return \ArrayType\ArrayOfSandbox
     */
    public function addToSandbox(\StructType\Sandbox $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Sandbox) {
            throw new \InvalidArgumentException(sprintf('The Sandbox property can only contain items of \StructType\Sandbox, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Sandbox[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Sandbox|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Sandbox|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Sandbox|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Sandbox|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Sandbox|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Sandbox
     */
    public function getAttributeName()
    {
        return 'Sandbox';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfSandbox
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
