<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPaymentsResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfPaymentsResponse extends AbstractStructArrayBase
{
    /**
     * The PaymentsResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PaymentsResponse[]
     */
    public $PaymentsResponse;
    /**
     * Constructor method for ArrayOfPaymentsResponse
     * @uses ArrayOfPaymentsResponse::setPaymentsResponse()
     * @param \StructType\PaymentsResponse[] $paymentsResponse
     */
    public function __construct(array $paymentsResponse = array())
    {
        $this
            ->setPaymentsResponse($paymentsResponse);
    }
    /**
     * Get PaymentsResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PaymentsResponse[]|null
     */
    public function getPaymentsResponse()
    {
        return isset($this->PaymentsResponse) ? $this->PaymentsResponse : null;
    }
    /**
     * Set PaymentsResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentsResponse[] $paymentsResponse
     * @return \ArrayType\ArrayOfPaymentsResponse
     */
    public function setPaymentsResponse(array $paymentsResponse = array())
    {
        foreach ($paymentsResponse as $arrayOfPaymentsResponsePaymentsResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfPaymentsResponsePaymentsResponseItem instanceof \StructType\PaymentsResponse) {
                throw new \InvalidArgumentException(sprintf('The PaymentsResponse property can only contain items of \StructType\PaymentsResponse, "%s" given', is_object($arrayOfPaymentsResponsePaymentsResponseItem) ? get_class($arrayOfPaymentsResponsePaymentsResponseItem) : gettype($arrayOfPaymentsResponsePaymentsResponseItem)), __LINE__);
            }
        }
        if (is_null($paymentsResponse) || (is_array($paymentsResponse) && empty($paymentsResponse))) {
            unset($this->PaymentsResponse);
        } else {
            $this->PaymentsResponse = $paymentsResponse;
        }
        return $this;
    }
    /**
     * Add item to PaymentsResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentsResponse $item
     * @return \ArrayType\ArrayOfPaymentsResponse
     */
    public function addToPaymentsResponse(\StructType\PaymentsResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentsResponse) {
            throw new \InvalidArgumentException(sprintf('The PaymentsResponse property can only contain items of \StructType\PaymentsResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentsResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PaymentsResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PaymentsResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PaymentsResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PaymentsResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PaymentsResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PaymentsResponse
     */
    public function getAttributeName()
    {
        return 'PaymentsResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPaymentsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
