<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPartyResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfPartyResponse extends AbstractStructArrayBase
{
    /**
     * The PartyResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PartyResponse[]
     */
    public $PartyResponse;
    /**
     * Constructor method for ArrayOfPartyResponse
     * @uses ArrayOfPartyResponse::setPartyResponse()
     * @param \StructType\PartyResponse[] $partyResponse
     */
    public function __construct(array $partyResponse = array())
    {
        $this
            ->setPartyResponse($partyResponse);
    }
    /**
     * Get PartyResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PartyResponse[]|null
     */
    public function getPartyResponse()
    {
        return isset($this->PartyResponse) ? $this->PartyResponse : null;
    }
    /**
     * Set PartyResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PartyResponse[] $partyResponse
     * @return \ArrayType\ArrayOfPartyResponse
     */
    public function setPartyResponse(array $partyResponse = array())
    {
        foreach ($partyResponse as $arrayOfPartyResponsePartyResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfPartyResponsePartyResponseItem instanceof \StructType\PartyResponse) {
                throw new \InvalidArgumentException(sprintf('The PartyResponse property can only contain items of \StructType\PartyResponse, "%s" given', is_object($arrayOfPartyResponsePartyResponseItem) ? get_class($arrayOfPartyResponsePartyResponseItem) : gettype($arrayOfPartyResponsePartyResponseItem)), __LINE__);
            }
        }
        if (is_null($partyResponse) || (is_array($partyResponse) && empty($partyResponse))) {
            unset($this->PartyResponse);
        } else {
            $this->PartyResponse = $partyResponse;
        }
        return $this;
    }
    /**
     * Add item to PartyResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\PartyResponse $item
     * @return \ArrayType\ArrayOfPartyResponse
     */
    public function addToPartyResponse(\StructType\PartyResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PartyResponse) {
            throw new \InvalidArgumentException(sprintf('The PartyResponse property can only contain items of \StructType\PartyResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PartyResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PartyResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PartyResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PartyResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PartyResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PartyResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PartyResponse
     */
    public function getAttributeName()
    {
        return 'PartyResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPartyResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
