<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfKitMemberResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfKitMemberResponse extends AbstractStructArrayBase
{
    /**
     * The KitMemberResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\KitMemberResponse[]
     */
    public $KitMemberResponse;
    /**
     * Constructor method for ArrayOfKitMemberResponse
     * @uses ArrayOfKitMemberResponse::setKitMemberResponse()
     * @param \StructType\KitMemberResponse[] $kitMemberResponse
     */
    public function __construct(array $kitMemberResponse = array())
    {
        $this
            ->setKitMemberResponse($kitMemberResponse);
    }
    /**
     * Get KitMemberResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\KitMemberResponse[]|null
     */
    public function getKitMemberResponse()
    {
        return isset($this->KitMemberResponse) ? $this->KitMemberResponse : null;
    }
    /**
     * Set KitMemberResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\KitMemberResponse[] $kitMemberResponse
     * @return \ArrayType\ArrayOfKitMemberResponse
     */
    public function setKitMemberResponse(array $kitMemberResponse = array())
    {
        foreach ($kitMemberResponse as $arrayOfKitMemberResponseKitMemberResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfKitMemberResponseKitMemberResponseItem instanceof \StructType\KitMemberResponse) {
                throw new \InvalidArgumentException(sprintf('The KitMemberResponse property can only contain items of \StructType\KitMemberResponse, "%s" given', is_object($arrayOfKitMemberResponseKitMemberResponseItem) ? get_class($arrayOfKitMemberResponseKitMemberResponseItem) : gettype($arrayOfKitMemberResponseKitMemberResponseItem)), __LINE__);
            }
        }
        if (is_null($kitMemberResponse) || (is_array($kitMemberResponse) && empty($kitMemberResponse))) {
            unset($this->KitMemberResponse);
        } else {
            $this->KitMemberResponse = $kitMemberResponse;
        }
        return $this;
    }
    /**
     * Add item to KitMemberResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\KitMemberResponse $item
     * @return \ArrayType\ArrayOfKitMemberResponse
     */
    public function addToKitMemberResponse(\StructType\KitMemberResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KitMemberResponse) {
            throw new \InvalidArgumentException(sprintf('The KitMemberResponse property can only contain items of \StructType\KitMemberResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->KitMemberResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\KitMemberResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\KitMemberResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\KitMemberResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\KitMemberResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\KitMemberResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string KitMemberResponse
     */
    public function getAttributeName()
    {
        return 'KitMemberResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfKitMemberResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
