<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfGroupOrder ArrayType
 * @subpackage Arrays
 */
class ArrayOfGroupOrder extends AbstractStructArrayBase
{
    /**
     * The GroupOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GroupOrder[]
     */
    public $GroupOrder;
    /**
     * Constructor method for ArrayOfGroupOrder
     * @uses ArrayOfGroupOrder::setGroupOrder()
     * @param \StructType\GroupOrder[] $groupOrder
     */
    public function __construct(array $groupOrder = array())
    {
        $this
            ->setGroupOrder($groupOrder);
    }
    /**
     * Get GroupOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GroupOrder[]|null
     */
    public function getGroupOrder()
    {
        return isset($this->GroupOrder) ? $this->GroupOrder : null;
    }
    /**
     * Set GroupOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GroupOrder[] $groupOrder
     * @return \ArrayType\ArrayOfGroupOrder
     */
    public function setGroupOrder(array $groupOrder = array())
    {
        foreach ($groupOrder as $arrayOfGroupOrderGroupOrderItem) {
            // validation for constraint: itemType
            if (!$arrayOfGroupOrderGroupOrderItem instanceof \StructType\GroupOrder) {
                throw new \InvalidArgumentException(sprintf('The GroupOrder property can only contain items of \StructType\GroupOrder, "%s" given', is_object($arrayOfGroupOrderGroupOrderItem) ? get_class($arrayOfGroupOrderGroupOrderItem) : gettype($arrayOfGroupOrderGroupOrderItem)), __LINE__);
            }
        }
        if (is_null($groupOrder) || (is_array($groupOrder) && empty($groupOrder))) {
            unset($this->GroupOrder);
        } else {
            $this->GroupOrder = $groupOrder;
        }
        return $this;
    }
    /**
     * Add item to GroupOrder value
     * @throws \InvalidArgumentException
     * @param \StructType\GroupOrder $item
     * @return \ArrayType\ArrayOfGroupOrder
     */
    public function addToGroupOrder(\StructType\GroupOrder $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GroupOrder) {
            throw new \InvalidArgumentException(sprintf('The GroupOrder property can only contain items of \StructType\GroupOrder, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->GroupOrder[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\GroupOrder|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\GroupOrder|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\GroupOrder|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\GroupOrder|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\GroupOrder|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string GroupOrder
     */
    public function getAttributeName()
    {
        return 'GroupOrder';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfGroupOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
