<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfExpectedPaymentResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfExpectedPaymentResponse extends AbstractStructArrayBase
{
    /**
     * The ExpectedPaymentResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExpectedPaymentResponse[]
     */
    public $ExpectedPaymentResponse;
    /**
     * Constructor method for ArrayOfExpectedPaymentResponse
     * @uses ArrayOfExpectedPaymentResponse::setExpectedPaymentResponse()
     * @param \StructType\ExpectedPaymentResponse[] $expectedPaymentResponse
     */
    public function __construct(array $expectedPaymentResponse = array())
    {
        $this
            ->setExpectedPaymentResponse($expectedPaymentResponse);
    }
    /**
     * Get ExpectedPaymentResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExpectedPaymentResponse[]|null
     */
    public function getExpectedPaymentResponse()
    {
        return isset($this->ExpectedPaymentResponse) ? $this->ExpectedPaymentResponse : null;
    }
    /**
     * Set ExpectedPaymentResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ExpectedPaymentResponse[] $expectedPaymentResponse
     * @return \ArrayType\ArrayOfExpectedPaymentResponse
     */
    public function setExpectedPaymentResponse(array $expectedPaymentResponse = array())
    {
        foreach ($expectedPaymentResponse as $arrayOfExpectedPaymentResponseExpectedPaymentResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfExpectedPaymentResponseExpectedPaymentResponseItem instanceof \StructType\ExpectedPaymentResponse) {
                throw new \InvalidArgumentException(sprintf('The ExpectedPaymentResponse property can only contain items of \StructType\ExpectedPaymentResponse, "%s" given', is_object($arrayOfExpectedPaymentResponseExpectedPaymentResponseItem) ? get_class($arrayOfExpectedPaymentResponseExpectedPaymentResponseItem) : gettype($arrayOfExpectedPaymentResponseExpectedPaymentResponseItem)), __LINE__);
            }
        }
        if (is_null($expectedPaymentResponse) || (is_array($expectedPaymentResponse) && empty($expectedPaymentResponse))) {
            unset($this->ExpectedPaymentResponse);
        } else {
            $this->ExpectedPaymentResponse = $expectedPaymentResponse;
        }
        return $this;
    }
    /**
     * Add item to ExpectedPaymentResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\ExpectedPaymentResponse $item
     * @return \ArrayType\ArrayOfExpectedPaymentResponse
     */
    public function addToExpectedPaymentResponse(\StructType\ExpectedPaymentResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExpectedPaymentResponse) {
            throw new \InvalidArgumentException(sprintf('The ExpectedPaymentResponse property can only contain items of \StructType\ExpectedPaymentResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ExpectedPaymentResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ExpectedPaymentResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ExpectedPaymentResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ExpectedPaymentResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ExpectedPaymentResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ExpectedPaymentResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ExpectedPaymentResponse
     */
    public function getAttributeName()
    {
        return 'ExpectedPaymentResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfExpectedPaymentResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
