<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerWallItemResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfCustomerWallItemResponse extends AbstractStructArrayBase
{
    /**
     * The CustomerWallItemResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerWallItemResponse[]
     */
    public $CustomerWallItemResponse;
    /**
     * Constructor method for ArrayOfCustomerWallItemResponse
     * @uses ArrayOfCustomerWallItemResponse::setCustomerWallItemResponse()
     * @param \StructType\CustomerWallItemResponse[] $customerWallItemResponse
     */
    public function __construct(array $customerWallItemResponse = array())
    {
        $this
            ->setCustomerWallItemResponse($customerWallItemResponse);
    }
    /**
     * Get CustomerWallItemResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerWallItemResponse[]|null
     */
    public function getCustomerWallItemResponse()
    {
        return isset($this->CustomerWallItemResponse) ? $this->CustomerWallItemResponse : null;
    }
    /**
     * Set CustomerWallItemResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerWallItemResponse[] $customerWallItemResponse
     * @return \ArrayType\ArrayOfCustomerWallItemResponse
     */
    public function setCustomerWallItemResponse(array $customerWallItemResponse = array())
    {
        foreach ($customerWallItemResponse as $arrayOfCustomerWallItemResponseCustomerWallItemResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerWallItemResponseCustomerWallItemResponseItem instanceof \StructType\CustomerWallItemResponse) {
                throw new \InvalidArgumentException(sprintf('The CustomerWallItemResponse property can only contain items of \StructType\CustomerWallItemResponse, "%s" given', is_object($arrayOfCustomerWallItemResponseCustomerWallItemResponseItem) ? get_class($arrayOfCustomerWallItemResponseCustomerWallItemResponseItem) : gettype($arrayOfCustomerWallItemResponseCustomerWallItemResponseItem)), __LINE__);
            }
        }
        if (is_null($customerWallItemResponse) || (is_array($customerWallItemResponse) && empty($customerWallItemResponse))) {
            unset($this->CustomerWallItemResponse);
        } else {
            $this->CustomerWallItemResponse = $customerWallItemResponse;
        }
        return $this;
    }
    /**
     * Add item to CustomerWallItemResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerWallItemResponse $item
     * @return \ArrayType\ArrayOfCustomerWallItemResponse
     */
    public function addToCustomerWallItemResponse(\StructType\CustomerWallItemResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerWallItemResponse) {
            throw new \InvalidArgumentException(sprintf('The CustomerWallItemResponse property can only contain items of \StructType\CustomerWallItemResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomerWallItemResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CustomerWallItemResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CustomerWallItemResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CustomerWallItemResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CustomerWallItemResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CustomerWallItemResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerWallItemResponse
     */
    public function getAttributeName()
    {
        return 'CustomerWallItemResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCustomerWallItemResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
