<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerSocialNetworksResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfCustomerSocialNetworksResponse extends AbstractStructArrayBase
{
    /**
     * The CustomerSocialNetworksResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerSocialNetworksResponse[]
     */
    public $CustomerSocialNetworksResponse;
    /**
     * Constructor method for ArrayOfCustomerSocialNetworksResponse
     * @uses ArrayOfCustomerSocialNetworksResponse::setCustomerSocialNetworksResponse()
     * @param \StructType\CustomerSocialNetworksResponse[] $customerSocialNetworksResponse
     */
    public function __construct(array $customerSocialNetworksResponse = array())
    {
        $this
            ->setCustomerSocialNetworksResponse($customerSocialNetworksResponse);
    }
    /**
     * Get CustomerSocialNetworksResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerSocialNetworksResponse[]|null
     */
    public function getCustomerSocialNetworksResponse()
    {
        return isset($this->CustomerSocialNetworksResponse) ? $this->CustomerSocialNetworksResponse : null;
    }
    /**
     * Set CustomerSocialNetworksResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSocialNetworksResponse[] $customerSocialNetworksResponse
     * @return \ArrayType\ArrayOfCustomerSocialNetworksResponse
     */
    public function setCustomerSocialNetworksResponse(array $customerSocialNetworksResponse = array())
    {
        foreach ($customerSocialNetworksResponse as $arrayOfCustomerSocialNetworksResponseCustomerSocialNetworksResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerSocialNetworksResponseCustomerSocialNetworksResponseItem instanceof \StructType\CustomerSocialNetworksResponse) {
                throw new \InvalidArgumentException(sprintf('The CustomerSocialNetworksResponse property can only contain items of \StructType\CustomerSocialNetworksResponse, "%s" given', is_object($arrayOfCustomerSocialNetworksResponseCustomerSocialNetworksResponseItem) ? get_class($arrayOfCustomerSocialNetworksResponseCustomerSocialNetworksResponseItem) : gettype($arrayOfCustomerSocialNetworksResponseCustomerSocialNetworksResponseItem)), __LINE__);
            }
        }
        if (is_null($customerSocialNetworksResponse) || (is_array($customerSocialNetworksResponse) && empty($customerSocialNetworksResponse))) {
            unset($this->CustomerSocialNetworksResponse);
        } else {
            $this->CustomerSocialNetworksResponse = $customerSocialNetworksResponse;
        }
        return $this;
    }
    /**
     * Add item to CustomerSocialNetworksResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSocialNetworksResponse $item
     * @return \ArrayType\ArrayOfCustomerSocialNetworksResponse
     */
    public function addToCustomerSocialNetworksResponse(\StructType\CustomerSocialNetworksResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSocialNetworksResponse) {
            throw new \InvalidArgumentException(sprintf('The CustomerSocialNetworksResponse property can only contain items of \StructType\CustomerSocialNetworksResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomerSocialNetworksResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CustomerSocialNetworksResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CustomerSocialNetworksResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CustomerSocialNetworksResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CustomerSocialNetworksResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CustomerSocialNetworksResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerSocialNetworksResponse
     */
    public function getAttributeName()
    {
        return 'CustomerSocialNetworksResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCustomerSocialNetworksResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
