<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfCustomerResponse extends AbstractStructArrayBase
{
    /**
     * The CustomerResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerResponse[]
     */
    public $CustomerResponse;
    /**
     * Constructor method for ArrayOfCustomerResponse
     * @uses ArrayOfCustomerResponse::setCustomerResponse()
     * @param \StructType\CustomerResponse[] $customerResponse
     */
    public function __construct(array $customerResponse = array())
    {
        $this
            ->setCustomerResponse($customerResponse);
    }
    /**
     * Get CustomerResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerResponse[]|null
     */
    public function getCustomerResponse()
    {
        return isset($this->CustomerResponse) ? $this->CustomerResponse : null;
    }
    /**
     * Set CustomerResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerResponse[] $customerResponse
     * @return \ArrayType\ArrayOfCustomerResponse
     */
    public function setCustomerResponse(array $customerResponse = array())
    {
        foreach ($customerResponse as $arrayOfCustomerResponseCustomerResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerResponseCustomerResponseItem instanceof \StructType\CustomerResponse) {
                throw new \InvalidArgumentException(sprintf('The CustomerResponse property can only contain items of \StructType\CustomerResponse, "%s" given', is_object($arrayOfCustomerResponseCustomerResponseItem) ? get_class($arrayOfCustomerResponseCustomerResponseItem) : gettype($arrayOfCustomerResponseCustomerResponseItem)), __LINE__);
            }
        }
        if (is_null($customerResponse) || (is_array($customerResponse) && empty($customerResponse))) {
            unset($this->CustomerResponse);
        } else {
            $this->CustomerResponse = $customerResponse;
        }
        return $this;
    }
    /**
     * Add item to CustomerResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerResponse $item
     * @return \ArrayType\ArrayOfCustomerResponse
     */
    public function addToCustomerResponse(\StructType\CustomerResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerResponse) {
            throw new \InvalidArgumentException(sprintf('The CustomerResponse property can only contain items of \StructType\CustomerResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomerResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CustomerResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CustomerResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CustomerResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CustomerResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CustomerResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerResponse
     */
    public function getAttributeName()
    {
        return 'CustomerResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCustomerResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
