<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerLeadsResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfCustomerLeadsResponse extends AbstractStructArrayBase
{
    /**
     * The CustomerLeadsResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerLeadsResponse[]
     */
    public $CustomerLeadsResponse;
    /**
     * Constructor method for ArrayOfCustomerLeadsResponse
     * @uses ArrayOfCustomerLeadsResponse::setCustomerLeadsResponse()
     * @param \StructType\CustomerLeadsResponse[] $customerLeadsResponse
     */
    public function __construct(array $customerLeadsResponse = array())
    {
        $this
            ->setCustomerLeadsResponse($customerLeadsResponse);
    }
    /**
     * Get CustomerLeadsResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerLeadsResponse[]|null
     */
    public function getCustomerLeadsResponse()
    {
        return isset($this->CustomerLeadsResponse) ? $this->CustomerLeadsResponse : null;
    }
    /**
     * Set CustomerLeadsResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerLeadsResponse[] $customerLeadsResponse
     * @return \ArrayType\ArrayOfCustomerLeadsResponse
     */
    public function setCustomerLeadsResponse(array $customerLeadsResponse = array())
    {
        foreach ($customerLeadsResponse as $arrayOfCustomerLeadsResponseCustomerLeadsResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerLeadsResponseCustomerLeadsResponseItem instanceof \StructType\CustomerLeadsResponse) {
                throw new \InvalidArgumentException(sprintf('The CustomerLeadsResponse property can only contain items of \StructType\CustomerLeadsResponse, "%s" given', is_object($arrayOfCustomerLeadsResponseCustomerLeadsResponseItem) ? get_class($arrayOfCustomerLeadsResponseCustomerLeadsResponseItem) : gettype($arrayOfCustomerLeadsResponseCustomerLeadsResponseItem)), __LINE__);
            }
        }
        if (is_null($customerLeadsResponse) || (is_array($customerLeadsResponse) && empty($customerLeadsResponse))) {
            unset($this->CustomerLeadsResponse);
        } else {
            $this->CustomerLeadsResponse = $customerLeadsResponse;
        }
        return $this;
    }
    /**
     * Add item to CustomerLeadsResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerLeadsResponse $item
     * @return \ArrayType\ArrayOfCustomerLeadsResponse
     */
    public function addToCustomerLeadsResponse(\StructType\CustomerLeadsResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerLeadsResponse) {
            throw new \InvalidArgumentException(sprintf('The CustomerLeadsResponse property can only contain items of \StructType\CustomerLeadsResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomerLeadsResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CustomerLeadsResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CustomerLeadsResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CustomerLeadsResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CustomerLeadsResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CustomerLeadsResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerLeadsResponse
     */
    public function getAttributeName()
    {
        return 'CustomerLeadsResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCustomerLeadsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
