<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAutoOrderDetailResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfAutoOrderDetailResponse extends AbstractStructArrayBase
{
    /**
     * The AutoOrderDetailResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AutoOrderDetailResponse[]
     */
    public $AutoOrderDetailResponse;
    /**
     * Constructor method for ArrayOfAutoOrderDetailResponse
     * @uses ArrayOfAutoOrderDetailResponse::setAutoOrderDetailResponse()
     * @param \StructType\AutoOrderDetailResponse[] $autoOrderDetailResponse
     */
    public function __construct(array $autoOrderDetailResponse = array())
    {
        $this
            ->setAutoOrderDetailResponse($autoOrderDetailResponse);
    }
    /**
     * Get AutoOrderDetailResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AutoOrderDetailResponse[]|null
     */
    public function getAutoOrderDetailResponse()
    {
        return isset($this->AutoOrderDetailResponse) ? $this->AutoOrderDetailResponse : null;
    }
    /**
     * Set AutoOrderDetailResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AutoOrderDetailResponse[] $autoOrderDetailResponse
     * @return \ArrayType\ArrayOfAutoOrderDetailResponse
     */
    public function setAutoOrderDetailResponse(array $autoOrderDetailResponse = array())
    {
        foreach ($autoOrderDetailResponse as $arrayOfAutoOrderDetailResponseAutoOrderDetailResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfAutoOrderDetailResponseAutoOrderDetailResponseItem instanceof \StructType\AutoOrderDetailResponse) {
                throw new \InvalidArgumentException(sprintf('The AutoOrderDetailResponse property can only contain items of \StructType\AutoOrderDetailResponse, "%s" given', is_object($arrayOfAutoOrderDetailResponseAutoOrderDetailResponseItem) ? get_class($arrayOfAutoOrderDetailResponseAutoOrderDetailResponseItem) : gettype($arrayOfAutoOrderDetailResponseAutoOrderDetailResponseItem)), __LINE__);
            }
        }
        if (is_null($autoOrderDetailResponse) || (is_array($autoOrderDetailResponse) && empty($autoOrderDetailResponse))) {
            unset($this->AutoOrderDetailResponse);
        } else {
            $this->AutoOrderDetailResponse = $autoOrderDetailResponse;
        }
        return $this;
    }
    /**
     * Add item to AutoOrderDetailResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\AutoOrderDetailResponse $item
     * @return \ArrayType\ArrayOfAutoOrderDetailResponse
     */
    public function addToAutoOrderDetailResponse(\StructType\AutoOrderDetailResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AutoOrderDetailResponse) {
            throw new \InvalidArgumentException(sprintf('The AutoOrderDetailResponse property can only contain items of \StructType\AutoOrderDetailResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AutoOrderDetailResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AutoOrderDetailResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AutoOrderDetailResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AutoOrderDetailResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AutoOrderDetailResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AutoOrderDetailResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AutoOrderDetailResponse
     */
    public function getAttributeName()
    {
        return 'AutoOrderDetailResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAutoOrderDetailResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
