<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfApiWhitelistResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfApiWhitelistResponse extends AbstractStructArrayBase
{
    /**
     * The ApiWhitelistResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ApiWhitelistResponse[]
     */
    public $ApiWhitelistResponse;
    /**
     * Constructor method for ArrayOfApiWhitelistResponse
     * @uses ArrayOfApiWhitelistResponse::setApiWhitelistResponse()
     * @param \StructType\ApiWhitelistResponse[] $apiWhitelistResponse
     */
    public function __construct(array $apiWhitelistResponse = array())
    {
        $this
            ->setApiWhitelistResponse($apiWhitelistResponse);
    }
    /**
     * Get ApiWhitelistResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ApiWhitelistResponse[]|null
     */
    public function getApiWhitelistResponse()
    {
        return isset($this->ApiWhitelistResponse) ? $this->ApiWhitelistResponse : null;
    }
    /**
     * Set ApiWhitelistResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ApiWhitelistResponse[] $apiWhitelistResponse
     * @return \ArrayType\ArrayOfApiWhitelistResponse
     */
    public function setApiWhitelistResponse(array $apiWhitelistResponse = array())
    {
        foreach ($apiWhitelistResponse as $arrayOfApiWhitelistResponseApiWhitelistResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfApiWhitelistResponseApiWhitelistResponseItem instanceof \StructType\ApiWhitelistResponse) {
                throw new \InvalidArgumentException(sprintf('The ApiWhitelistResponse property can only contain items of \StructType\ApiWhitelistResponse, "%s" given', is_object($arrayOfApiWhitelistResponseApiWhitelistResponseItem) ? get_class($arrayOfApiWhitelistResponseApiWhitelistResponseItem) : gettype($arrayOfApiWhitelistResponseApiWhitelistResponseItem)), __LINE__);
            }
        }
        if (is_null($apiWhitelistResponse) || (is_array($apiWhitelistResponse) && empty($apiWhitelistResponse))) {
            unset($this->ApiWhitelistResponse);
        } else {
            $this->ApiWhitelistResponse = $apiWhitelistResponse;
        }
        return $this;
    }
    /**
     * Add item to ApiWhitelistResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\ApiWhitelistResponse $item
     * @return \ArrayType\ArrayOfApiWhitelistResponse
     */
    public function addToApiWhitelistResponse(\StructType\ApiWhitelistResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ApiWhitelistResponse) {
            throw new \InvalidArgumentException(sprintf('The ApiWhitelistResponse property can only contain items of \StructType\ApiWhitelistResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ApiWhitelistResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ApiWhitelistResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ApiWhitelistResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ApiWhitelistResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ApiWhitelistResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ApiWhitelistResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ApiWhitelistResponse
     */
    public function getAttributeName()
    {
        return 'ApiWhitelistResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfApiWhitelistResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
