<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfApiRequest ArrayType
 * @subpackage Arrays
 */
class ArrayOfApiRequest extends AbstractStructArrayBase
{
    /**
     * The ApiRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ApiRequest[]
     */
    public $ApiRequest;
    /**
     * Constructor method for ArrayOfApiRequest
     * @uses ArrayOfApiRequest::setApiRequest()
     * @param \StructType\ApiRequest[] $apiRequest
     */
    public function __construct(array $apiRequest = array())
    {
        $this
            ->setApiRequest($apiRequest);
    }
    /**
     * Get ApiRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ApiRequest[]|null
     */
    public function getApiRequest()
    {
        return isset($this->ApiRequest) ? $this->ApiRequest : null;
    }
    /**
     * Set ApiRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ApiRequest[] $apiRequest
     * @return \ArrayType\ArrayOfApiRequest
     */
    public function setApiRequest(array $apiRequest = array())
    {
        foreach ($apiRequest as $arrayOfApiRequestApiRequestItem) {
            // validation for constraint: itemType
            if (!$arrayOfApiRequestApiRequestItem instanceof \StructType\ApiRequest) {
                throw new \InvalidArgumentException(sprintf('The ApiRequest property can only contain items of \StructType\ApiRequest, "%s" given', is_object($arrayOfApiRequestApiRequestItem) ? get_class($arrayOfApiRequestApiRequestItem) : gettype($arrayOfApiRequestApiRequestItem)), __LINE__);
            }
        }
        if (is_null($apiRequest) || (is_array($apiRequest) && empty($apiRequest))) {
            unset($this->ApiRequest);
        } else {
            $this->ApiRequest = $apiRequest;
        }
        return $this;
    }
    /**
     * Add item to ApiRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\ApiRequest $item
     * @return \ArrayType\ArrayOfApiRequest
     */
    public function addToApiRequest(\StructType\ApiRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ApiRequest) {
            throw new \InvalidArgumentException(sprintf('The ApiRequest property can only contain items of \StructType\ApiRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ApiRequest[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ApiRequest|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ApiRequest|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ApiRequest|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ApiRequest|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ApiRequest|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ApiRequest
     */
    public function getAttributeName()
    {
        return 'ApiRequest';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfApiRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
