<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.exigo.com/3.0/ExigoApi.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.exigo.com/3.0/ExigoApi.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for GetVolumes operation/method
 */
if ($get->GetVolumes(new \StructType\GetVolumesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetWarehouses operation/method
 */
if ($get->GetWarehouses(new \StructType\GetWarehousesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOrderInvoice operation/method
 */
if ($get->GetOrderInvoice(new \StructType\GetOrderInvoiceRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAccountDirectDeposit operation/method
 */
if ($get->GetAccountDirectDeposit(new \StructType\GetAccountDirectDepositRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetApiWhitelist operation/method
 */
if ($get->GetApiWhitelist(new \StructType\GetApiWhitelistRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAutoOrders operation/method
 */
if ($get->GetAutoOrders(new \StructType\GetAutoOrdersRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBinaryPreference operation/method
 */
if ($get->GetBinaryPreference(new \StructType\GetBinaryPreferenceRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCompanyLanguages operation/method
 */
if ($get->GetCompanyLanguages(new \StructType\GetLanguagesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCompanyNews operation/method
 */
if ($get->GetCompanyNews(new \StructType\GetCompanyNewsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCompanyNewsItem operation/method
 */
if ($get->GetCompanyNewsItem(new \StructType\GetCompanyNewsItemRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCountryRegions operation/method
 */
if ($get->GetCountryRegions(new \StructType\GetCountryRegionsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerBalances operation/method
 */
if ($get->GetCustomerBalances(new \StructType\GetCustomerBalancesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerBilling operation/method
 */
if ($get->GetCustomerBilling(new \StructType\GetCustomerBillingRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerExtended operation/method
 */
if ($get->GetCustomerExtended(new \StructType\GetCustomerExtendedRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerLeads operation/method
 */
if ($get->GetCustomerLeads(new \StructType\GetCustomerLeadsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerLeadSocialNetworks operation/method
 */
if ($get->GetCustomerLeadSocialNetworks(new \StructType\GetCustomerLeadSocialNetworksRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerNotes operation/method
 */
if ($get->GetCustomerNotes(new \StructType\GetCustomerNotesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomers operation/method
 */
if ($get->GetCustomers(new \StructType\GetCustomersRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerSite operation/method
 */
if ($get->GetCustomerSite(new \StructType\GetCustomerSiteRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerSocialNetworks operation/method
 */
if ($get->GetCustomerSocialNetworks(new \StructType\GetCustomerSocialNetworksRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerWall operation/method
 */
if ($get->GetCustomerWall(new \StructType\GetCustomerWallRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomReport operation/method
 */
if ($get->GetCustomReport(new \StructType\GetCustomReportRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDownline operation/method
 */
if ($get->GetDownline(new \StructType\GetDownlineRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEmailAttachment operation/method
 */
if ($get->GetEmailAttachment(new \StructType\GetEmailAttachmentRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetExtendedDbEntity operation/method
 */
if ($get->GetExtendedDbEntity(new \StructType\GetEntityRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetExtendedDbSchema operation/method
 */
if ($get->GetExtendedDbSchema(new \StructType\GetSchemaRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFileContents operation/method
 */
if ($get->GetFileContents(new \StructType\GetFileContentsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFiles operation/method
 */
if ($get->GetFiles(new \StructType\GetFilesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetGuests operation/method
 */
if ($get->GetGuests(new \StructType\GetGuestsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetGuestSocialNetworks operation/method
 */
if ($get->GetGuestSocialNetworks(new \StructType\GetGuestSocialNetworksRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetItemCountryRegion operation/method
 */
if ($get->GetItemCountryRegion(new \StructType\GetItemCountryRegionRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetItems operation/method
 */
if ($get->GetItems(new \StructType\GetItemsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLoginSession operation/method
 */
if ($get->GetLoginSession(new \StructType\GetLoginSessionRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOrders operation/method
 */
if ($get->GetOrders(new \StructType\GetOrdersRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOrderTotals operation/method
 */
if ($get->GetOrderTotals(new \StructType\GetOrderTotalsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetParties operation/method
 */
if ($get->GetParties(new \StructType\GetPartiesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPartyGuests operation/method
 */
if ($get->GetPartyGuests(new \StructType\GetPartyGuestsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPayments operation/method
 */
if ($get->GetPayments(new \StructType\GetPaymentsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPointAccount operation/method
 */
if ($get->GetPointAccount(new \StructType\GetPointAccountRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetQualificationOverrides operation/method
 */
if ($get->GetQualificationOverrides(new \StructType\GetQualificationOverridesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRandomMessage operation/method
 */
if ($get->GetRandomMessage(new \StructType\GetRandomMessageRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRankQualifications operation/method
 */
if ($get->GetRankQualifications(new \StructType\GetRankQualificationsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRealTimeCommissionDetail operation/method
 */
if ($get->GetRealTimeCommissionDetail(new \StructType\GetRealTimeCommissionDetailRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRealTimeCommissions operation/method
 */
if ($get->GetRealTimeCommissions(new \StructType\GetRealTimeCommissionsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetReport operation/method
 */
if ($get->GetReport(new \StructType\GetReportRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCommissionReport operation/method
 */
if ($get->GetCommissionReport(new \StructType\GetCommissionReportRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSandbox operation/method
 */
if ($get->GetSandbox(new \StructType\GetSandboxRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSession operation/method
 */
if ($get->GetSession(new \StructType\GetSessionRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetShipMethods operation/method
 */
if ($get->GetShipMethods(new \StructType\GetShipMethodsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetShoppingCart operation/method
 */
if ($get->GetShoppingCart(new \StructType\GetShoppingCartRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSubscription operation/method
 */
if ($get->GetSubscription(new \StructType\GetSubscriptionRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUpline operation/method
 */
if ($get->GetUpline(new \StructType\GetUplineRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserPermissions operation/method
 */
if ($get->GetUserPermissions(new \StructType\GetUserPermissionsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Login ServiceType
 */
$login = new \ServiceType\Login($options);
$login->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for LoginCustomer operation/method
 */
if ($login->LoginCustomer(new \StructType\LoginCustomerRequest()) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Samples for Merge ServiceType
 */
$merge = new \ServiceType\Merge($options);
$merge->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for MergeCustomer operation/method
 */
if ($merge->MergeCustomer(new \StructType\MergeCustomerRequest()) !== false) {
    print_r($merge->getResult());
} else {
    print_r($merge->getLastError());
}
/**
 * Samples for Move ServiceType
 */
$move = new \ServiceType\Move($options);
$move->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for MoveEmail operation/method
 */
if ($move->MoveEmail(new \StructType\MoveEmailRequest()) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Samples for Opt ServiceType
 */
$opt = new \ServiceType\Opt($options);
$opt->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for OptInEmail operation/method
 */
if ($opt->OptInEmail(new \StructType\OptInEmailRequest()) !== false) {
    print_r($opt->getResult());
} else {
    print_r($opt->getLastError());
}
/**
 * Sample call for OptInPushNotification operation/method
 */
if ($opt->OptInPushNotification(new \StructType\OptInPushNotificationRequest()) !== false) {
    print_r($opt->getResult());
} else {
    print_r($opt->getLastError());
}
/**
 * Sample call for OptInSms operation/method
 */
if ($opt->OptInSms(new \StructType\OptInSmsRequest()) !== false) {
    print_r($opt->getResult());
} else {
    print_r($opt->getLastError());
}
/**
 * Sample call for OptOutEmail operation/method
 */
if ($opt->OptOutEmail(new \StructType\OptOutEmailRequest()) !== false) {
    print_r($opt->getResult());
} else {
    print_r($opt->getLastError());
}
/**
 * Sample call for OptOutPushNotification operation/method
 */
if ($opt->OptOutPushNotification(new \StructType\OptOutPushNotificationRequest()) !== false) {
    print_r($opt->getResult());
} else {
    print_r($opt->getLastError());
}
/**
 * Sample call for OptOutSms operation/method
 */
if ($opt->OptOutSms(new \StructType\OptOutSmsRequest()) !== false) {
    print_r($opt->getResult());
} else {
    print_r($opt->getLastError());
}
/**
 * Samples for Place ServiceType
 */
$place = new \ServiceType\Place($options);
$place->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for PlaceBinaryNode operation/method
 */
if ($place->PlaceBinaryNode(new \StructType\PlaceBinaryNodeRequest()) !== false) {
    print_r($place->getResult());
} else {
    print_r($place->getLastError());
}
/**
 * Sample call for PlaceEnrollerNode operation/method
 */
if ($place->PlaceEnrollerNode(new \StructType\PlaceEnrollerNodeRequest()) !== false) {
    print_r($place->getResult());
} else {
    print_r($place->getLastError());
}
/**
 * Sample call for PlaceMatrixNode operation/method
 */
if ($place->PlaceMatrixNode(new \StructType\PlaceMatrixNodeRequest()) !== false) {
    print_r($place->getResult());
} else {
    print_r($place->getLastError());
}
/**
 * Sample call for PlaceStackNode operation/method
 */
if ($place->PlaceStackNode(new \StructType\PlaceStackNodeRequest()) !== false) {
    print_r($place->getResult());
} else {
    print_r($place->getLastError());
}
/**
 * Sample call for PlaceUniLevelNode operation/method
 */
if ($place->PlaceUniLevelNode(new \StructType\PlaceUniLevelNodeRequest()) !== false) {
    print_r($place->getResult());
} else {
    print_r($place->getLastError());
}
/**
 * Samples for Process ServiceType
 */
$process = new \ServiceType\Process($options);
$process->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for ProcessTransaction operation/method
 */
if ($process->ProcessTransaction(new \StructType\TransactionalRequest()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Samples for Refresh ServiceType
 */
$refresh = new \ServiceType\Refresh($options);
$refresh->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for RefreshSandbox operation/method
 */
if ($refresh->RefreshSandbox(new \StructType\RefreshSandboxRequest()) !== false) {
    print_r($refresh->getResult());
} else {
    print_r($refresh->getLastError());
}
/**
 * Samples for Refund ServiceType
 */
$refund = new \ServiceType\Refund($options);
$refund->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for RefundPriorCreditCardCharge operation/method
 */
if ($refund->RefundPriorCreditCardCharge(new \StructType\RefundPriorCreditCardChargeRequest()) !== false) {
    print_r($refund->getResult());
} else {
    print_r($refund->getLastError());
}
/**
 * Sample call for RefundPriorWalletCharge operation/method
 */
if ($refund->RefundPriorWalletCharge(new \StructType\RefundPriorWalletChargeRequest()) !== false) {
    print_r($refund->getResult());
} else {
    print_r($refund->getLastError());
}
/**
 * Samples for Remove ServiceType
 */
$remove = new \ServiceType\Remove($options);
$remove->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for RemoveApiWhitelist operation/method
 */
if ($remove->RemoveApiWhitelist(new \StructType\RemoveApiWhitelistRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for RemovePartyGuests operation/method
 */
if ($remove->RemovePartyGuests(new \StructType\RemovePartyGuestsRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \ServiceType\Send($options);
$send->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for SendEmail operation/method
 */
if ($send->SendEmail(new \StructType\SendEmailRequest()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendSms operation/method
 */
if ($send->SendSms(new \StructType\SendSmsRequest()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ServiceType\Set($options);
$set->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for SetAccountChecking operation/method
 */
if ($set->SetAccountChecking(new \StructType\SetAccountCheckingRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetAccountCreditCard operation/method
 */
if ($set->SetAccountCreditCard(new \StructType\SetAccountCreditCardRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetAccountCreditCardToken operation/method
 */
if ($set->SetAccountCreditCardToken(new \StructType\SetAccountCreditCardTokenRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetAccountDirectDeposit operation/method
 */
if ($set->SetAccountDirectDeposit(new \StructType\SetAccountDirectDepositRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetAccountWallet operation/method
 */
if ($set->SetAccountWallet(new \StructType\SetAccountWalletRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetBinaryPreference operation/method
 */
if ($set->SetBinaryPreference(new \StructType\SetBinaryPreferenceRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetCustomerLeadSocialNetworks operation/method
 */
if ($set->SetCustomerLeadSocialNetworks(new \StructType\SetCustomerLeadSocialNetworksRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetCustomerSite operation/method
 */
if ($set->SetCustomerSite(new \StructType\SetCustomerSiteRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetCustomerSiteImage operation/method
 */
if ($set->SetCustomerSiteImage(new \StructType\SetCustomerSiteImageRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetCustomerSocialNetworks operation/method
 */
if ($set->SetCustomerSocialNetworks(new \StructType\SetCustomerSocialNetworksRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetGuestSocialNetworks operation/method
 */
if ($set->SetGuestSocialNetworks(new \StructType\SetGuestSocialNetworksRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetImageFile operation/method
 */
if ($set->SetImageFile(new \StructType\SetImageFileRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetItemCountryRegion operation/method
 */
if ($set->SetItemCountryRegion(new \StructType\SetItemCountryRegionRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetItemImage operation/method
 */
if ($set->SetItemImage(new \StructType\SetItemImageRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetItemKitMembers operation/method
 */
if ($set->SetItemKitMembers(new \StructType\SetItemKitMembersRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetItemPrice operation/method
 */
if ($set->SetItemPrice(new \StructType\SetItemPriceRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetItemWarehouse operation/method
 */
if ($set->SetItemWarehouse(new \StructType\SetItemWarehouseRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetQualificationOverride operation/method
 */
if ($set->SetQualificationOverride(new \StructType\SetQualificationOverrideRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetSession operation/method
 */
if ($set->SetSession(new \StructType\SetSessionRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Start ServiceType
 */
$start = new \ServiceType\Start($options);
$start->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for StartSandbox operation/method
 */
if ($start->StartSandbox(new \StructType\StartSandboxRequest()) !== false) {
    print_r($start->getResult());
} else {
    print_r($start->getLastError());
}
/**
 * Samples for Stop ServiceType
 */
$stop = new \ServiceType\Stop($options);
$stop->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for StopSandbox operation/method
 */
if ($stop->StopSandbox(new \StructType\StopSandboxRequest()) !== false) {
    print_r($stop->getResult());
} else {
    print_r($stop->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
$update->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for UpdateCalendarItem operation/method
 */
if ($update->UpdateCalendarItem(new \StructType\UpdateCalendarItemRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateCustomer operation/method
 */
if ($update->UpdateCustomer(new \StructType\UpdateCustomerRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateCustomerContact operation/method
 */
if ($update->UpdateCustomerContact(new \StructType\UpdateCustomerContactRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateCustomerExtended operation/method
 */
if ($update->UpdateCustomerExtended(new \StructType\UpdateCustomerExtendedRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateCustomerLead operation/method
 */
if ($update->UpdateCustomerLead(new \StructType\UpdateCustomerLeadRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateEmailStatus operation/method
 */
if ($update->UpdateEmailStatus(new \StructType\UpdateEmailStatusRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateEmailTemplate operation/method
 */
if ($update->UpdateEmailTemplate(new \StructType\UpdateEmailTemplateRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateExtendedDbEntity operation/method
 */
if ($update->UpdateExtendedDbEntity(new \StructType\UpdateEntityRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateGuest operation/method
 */
if ($update->UpdateGuest(new \StructType\UpdateGuestRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateItem operation/method
 */
if ($update->UpdateItem(new \StructType\UpdateItemRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateMailFolder operation/method
 */
if ($update->UpdateMailFolder(new \StructType\UpdateMailFolderRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateOrder operation/method
 */
if ($update->UpdateOrder(new \StructType\UpdateOrderRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateOrderDetail operation/method
 */
if ($update->UpdateOrderDetail(new \StructType\UpdateOrderDetailRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateParty operation/method
 */
if ($update->UpdateParty(new \StructType\UpdatePartyRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateWebCategory operation/method
 */
if ($update->UpdateWebCategory(new \StructType\UpdateWebCategoryRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateAutoOrder operation/method
 */
if ($update->UpdateAutoOrder(new \StructType\UpdateAutoOrderRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateAutoOrderDetail operation/method
 */
if ($update->UpdateAutoOrderDetail(new \StructType\UpdateAutoOrderDetailRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Validate ServiceType
 */
$validate = new \ServiceType\Validate($options);
$validate->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for Validate operation/method
 */
if ($validate->Validate(new \StructType\ValidateRequest()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Samples for Verify ServiceType
 */
$verify = new \ServiceType\Verify($options);
$verify->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for VerifyAddress operation/method
 */
if ($verify->VerifyAddress(new \StructType\VerifyAddressRequest()) !== false) {
    print_r($verify->getResult());
} else {
    print_r($verify->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
$add->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for AddPartyGuests operation/method
 */
if ($add->AddPartyGuests(new \StructType\AddPartyGuestsRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddProductsToCategory operation/method
 */
if ($add->AddProductsToCategory(new \StructType\AddProductsToCategoryRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Adjust ServiceType
 */
$adjust = new \ServiceType\Adjust($options);
$adjust->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for AdjustInventory operation/method
 */
if ($adjust->AdjustInventory(new \StructType\AdjustInventoryRequest()) !== false) {
    print_r($adjust->getResult());
} else {
    print_r($adjust->getLastError());
}
/**
 * Samples for Append ServiceType
 */
$append = new \ServiceType\Append($options);
$append->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for AppendCustomerNotes operation/method
 */
if ($append->AppendCustomerNotes(new \StructType\AppendCustomerNotesRequest()) !== false) {
    print_r($append->getResult());
} else {
    print_r($append->getLastError());
}
/**
 * Samples for Authenticate ServiceType
 */
$authenticate = new \ServiceType\Authenticate($options);
$authenticate->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for AuthenticateCustomer operation/method
 */
if ($authenticate->AuthenticateCustomer(new \StructType\AuthenticateCustomerRequest()) !== false) {
    print_r($authenticate->getResult());
} else {
    print_r($authenticate->getLastError());
}
/**
 * Sample call for AuthenticateUser operation/method
 */
if ($authenticate->AuthenticateUser(new \StructType\AuthenticateUserRequest()) !== false) {
    print_r($authenticate->getResult());
} else {
    print_r($authenticate->getLastError());
}
/**
 * Samples for Authorize ServiceType
 */
$authorize = new \ServiceType\Authorize($options);
$authorize->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for AuthorizeOnlyCreditCardToken operation/method
 */
if ($authorize->AuthorizeOnlyCreditCardToken(new \StructType\AuthorizeOnlyCreditCardTokenRequest()) !== false) {
    print_r($authorize->getResult());
} else {
    print_r($authorize->getLastError());
}
/**
 * Sample call for AuthorizeOnlyCreditCardTokenOnFile operation/method
 */
if ($authorize->AuthorizeOnlyCreditCardTokenOnFile(new \StructType\AuthorizeOnlyCreditCardTokenOnFileRequest()) !== false) {
    print_r($authorize->getResult());
} else {
    print_r($authorize->getLastError());
}
/**
 * Samples for Calculate ServiceType
 */
$calculate = new \ServiceType\Calculate($options);
$calculate->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for CalculateOrder operation/method
 */
if ($calculate->CalculateOrder(new \StructType\CalculateOrderRequest()) !== false) {
    print_r($calculate->getResult());
} else {
    print_r($calculate->getLastError());
}
/**
 * Samples for Change ServiceType
 */
$change = new \ServiceType\Change($options);
$change->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for ChangeAutoOrderStatus operation/method
 */
if ($change->ChangeAutoOrderStatus(new \StructType\ChangeAutoOrderStatusRequest()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Sample call for ChangeOrderStatus operation/method
 */
if ($change->ChangeOrderStatus(new \StructType\ChangeOrderStatusRequest()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Sample call for ChangeOrderStatusBatch operation/method
 */
if ($change->ChangeOrderStatusBatch(new \StructType\ChangeOrderStatusBatchRequest()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Samples for Charge ServiceType
 */
$charge = new \ServiceType\Charge($options);
$charge->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for ChargeCreditCard operation/method
 */
if ($charge->ChargeCreditCard(new \StructType\ChargeCreditCardRequest()) !== false) {
    print_r($charge->getResult());
} else {
    print_r($charge->getLastError());
}
/**
 * Sample call for ChargeCreditCardOnFile operation/method
 */
if ($charge->ChargeCreditCardOnFile(new \StructType\ChargeCreditCardOnFileRequest()) !== false) {
    print_r($charge->getResult());
} else {
    print_r($charge->getLastError());
}
/**
 * Sample call for ChargeCreditCardToken operation/method
 */
if ($charge->ChargeCreditCardToken(new \StructType\ChargeCreditCardTokenRequest()) !== false) {
    print_r($charge->getResult());
} else {
    print_r($charge->getLastError());
}
/**
 * Sample call for ChargeCreditCardTokenOnFile operation/method
 */
if ($charge->ChargeCreditCardTokenOnFile(new \StructType\ChargeCreditCardTokenOnFileRequest()) !== false) {
    print_r($charge->getResult());
} else {
    print_r($charge->getLastError());
}
/**
 * Sample call for ChargeGroupOrderCreditCardToken operation/method
 */
if ($charge->ChargeGroupOrderCreditCardToken(new \StructType\ChargeGroupOrderCreditCardTokenRequest()) !== false) {
    print_r($charge->getResult());
} else {
    print_r($charge->getLastError());
}
/**
 * Sample call for ChargePriorAuthorization operation/method
 */
if ($charge->ChargePriorAuthorization(new \StructType\ChargePriorAuthorizationRequest()) !== false) {
    print_r($charge->getResult());
} else {
    print_r($charge->getLastError());
}
/**
 * Sample call for ChargeWalletAccount operation/method
 */
if ($charge->ChargeWalletAccount(new \StructType\ChargeWalletAccountRequest()) !== false) {
    print_r($charge->getResult());
} else {
    print_r($charge->getLastError());
}
/**
 * Sample call for ChargeWalletAccountOnFile operation/method
 */
if ($charge->ChargeWalletAccountOnFile(new \StructType\ChargeWalletAccountOnFileRequest()) !== false) {
    print_r($charge->getResult());
} else {
    print_r($charge->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
$create->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for CreateApiWhitelist operation/method
 */
if ($create->CreateApiWhitelist(new \StructType\CreateApiWhitelistRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateAutoOrder operation/method
 */
if ($create->CreateAutoOrder(new \StructType\CreateAutoOrderRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateBill operation/method
 */
if ($create->CreateBill(new \StructType\CreateBillRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateCalendarItem operation/method
 */
if ($create->CreateCalendarItem(new \StructType\CreateCalendarItemRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateCustomer operation/method
 */
if ($create->CreateCustomer(new \StructType\CreateCustomerRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateCustomerBalanceAdjustment operation/method
 */
if ($create->CreateCustomerBalanceAdjustment(new \StructType\CreateCustomerBalanceAdjustmentRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateCustomerContact operation/method
 */
if ($create->CreateCustomerContact(new \StructType\CreateCustomerContactRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateCustomerExtended operation/method
 */
if ($create->CreateCustomerExtended(new \StructType\CreateCustomerExtendedRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateCustomerFile operation/method
 */
if ($create->CreateCustomerFile(new \StructType\CreateCustomerFileRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateCustomerInquiry operation/method
 */
if ($create->CreateCustomerInquiry(new \StructType\CreateCustomerInquiryRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateCustomerLead operation/method
 */
if ($create->CreateCustomerLead(new \StructType\CreateCustomerLeadRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateCustomerWallItem operation/method
 */
if ($create->CreateCustomerWallItem(new \StructType\CreateCustomerWallItemRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateEmail operation/method
 */
if ($create->CreateEmail(new \StructType\CreateEmailRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateEmailTemplate operation/method
 */
if ($create->CreateEmailTemplate(new \StructType\CreateEmailTemplateRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateExpectedBankWire operation/method
 */
if ($create->CreateExpectedBankWire(new \StructType\CreateExpectedBankWireRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateExpectedPayment operation/method
 */
if ($create->CreateExpectedPayment(new \StructType\CreateExpectedPaymentRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateExtendedDbEntity operation/method
 */
if ($create->CreateExtendedDbEntity(new \StructType\CreateEntityRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateExtendedDbSchema operation/method
 */
if ($create->CreateExtendedDbSchema(new \StructType\CreateExtendedDbSchemeRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateGuest operation/method
 */
if ($create->CreateGuest(new \StructType\CreateGuestRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateItem operation/method
 */
if ($create->CreateItem(new \StructType\CreateItemRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateMailFolder operation/method
 */
if ($create->CreateMailFolder(new \StructType\CreateMailFolderRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateOrder operation/method
 */
if ($create->CreateOrder(new \StructType\CreateOrderRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateOrderDetail operation/method
 */
if ($create->CreateOrderDetail(new \StructType\CreateOrderDetailRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateOrderImport operation/method
 */
if ($create->CreateOrderImport(new \StructType\CreateOrderImportRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateParty operation/method
 */
if ($create->CreateParty(new \StructType\CreatePartyRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreatePayment operation/method
 */
if ($create->CreatePayment(new \StructType\CreatePaymentRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreatePaymentCheck operation/method
 */
if ($create->CreatePaymentCheck(new \StructType\CreatePaymentCheckRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreatePaymentCreditCard operation/method
 */
if ($create->CreatePaymentCreditCard(new \StructType\CreatePaymentCreditCardRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreatePaymentPointAccount operation/method
 */
if ($create->CreatePaymentPointAccount(new \StructType\CreatePaymentPointAccountRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreatePaymentWallet operation/method
 */
if ($create->CreatePaymentWallet(new \StructType\CreatePaymentWalletRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreatePayout operation/method
 */
if ($create->CreatePayout(new \StructType\CreatePayoutRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreatePointTransaction operation/method
 */
if ($create->CreatePointTransaction(new \StructType\CreatePointTransactionRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateVendorBill operation/method
 */
if ($create->CreateVendorBill(new \StructType\CreateVendorBillRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateWarehouse operation/method
 */
if ($create->CreateWarehouse(new \StructType\CreateWarehouseRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateWebCategory operation/method
 */
if ($create->CreateWebCategory(new \StructType\CreateWebCategoryRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Debit ServiceType
 */
$debit = new \ServiceType\Debit($options);
$debit->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for DebitBankAccount operation/method
 */
if ($debit->DebitBankAccount(new \StructType\DebitBankAccountRequest()) !== false) {
    print_r($debit->getResult());
} else {
    print_r($debit->getLastError());
}
/**
 * Sample call for DebitBankAccountOnFile operation/method
 */
if ($debit->DebitBankAccountOnFile(new \StructType\DebitBankAccountOnFileRequest()) !== false) {
    print_r($debit->getResult());
} else {
    print_r($debit->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
$delete->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for DeleteCalendarItem operation/method
 */
if ($delete->DeleteCalendarItem(new \StructType\DeleteCalendarItemRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteCustomerContact operation/method
 */
if ($delete->DeleteCustomerContact(new \StructType\DeleteCustomerContactRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteCustomerExtended operation/method
 */
if ($delete->DeleteCustomerExtended(new \StructType\DeleteCustomerExtendedRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteCustomerLead operation/method
 */
if ($delete->DeleteCustomerLead(new \StructType\DeleteCustomerLeadRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteCustomerWallItem operation/method
 */
if ($delete->DeleteCustomerWallItem(new \StructType\DeleteCustomerWallItemRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteEmail operation/method
 */
if ($delete->DeleteEmail(new \StructType\DeleteEmailRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteEmailTemplate operation/method
 */
if ($delete->DeleteEmailTemplate(new \StructType\DeleteEmailTemplateRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteExtendedDbEntity operation/method
 */
if ($delete->DeleteExtendedDbEntity(new \StructType\DeleteEntityRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteExtendedDbSchema operation/method
 */
if ($delete->DeleteExtendedDbSchema(new \StructType\DeleteSchemaRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteMailFolder operation/method
 */
if ($delete->DeleteMailFolder(new \StructType\DeleteMailFolderRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteOrderDetail operation/method
 */
if ($delete->DeleteOrderDetail(new \StructType\DeleteOrderDetailRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteProductFromCategory operation/method
 */
if ($delete->DeleteProductFromCategory(new \StructType\DeleteProductFromCategoryRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteQualificationOverride operation/method
 */
if ($delete->DeleteQualificationOverride(new \StructType\DeleteQualificationOverrideRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteWebCategory operation/method
 */
if ($delete->DeleteWebCategory(new \StructType\DeleteWebCategoryRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Dequeue ServiceType
 */
$dequeue = new \ServiceType\Dequeue($options);
$dequeue->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for DequeueCustomerEvents operation/method
 */
if ($dequeue->DequeueCustomerEvents(new \StructType\DequeueCustomerEventsRequest()) !== false) {
    print_r($dequeue->getResult());
} else {
    print_r($dequeue->getLastError());
}
/**
 * Samples for Empty ServiceType
 */
$empty = new \ServiceType\_Empty($options);
$empty->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for EmptyMailFolder operation/method
 */
if ($empty->EmptyMailFolder(new \StructType\EmptyMailFolderRequest()) !== false) {
    print_r($empty->getResult());
} else {
    print_r($empty->getLastError());
}
/**
 * Samples for Ensure ServiceType
 */
$ensure = new \ServiceType\Ensure($options);
$ensure->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for EnsureMailFolders operation/method
 */
if ($ensure->EnsureMailFolders(new \StructType\EnsureMailFoldersRequest()) !== false) {
    print_r($ensure->getResult());
} else {
    print_r($ensure->getLastError());
}
/**
 * Samples for Fire ServiceType
 */
$fire = new \ServiceType\Fire($options);
$fire->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for FireResponder operation/method
 */
if ($fire->FireResponder(new \StructType\FireResponderRequest()) !== false) {
    print_r($fire->getResult());
} else {
    print_r($fire->getLastError());
}
/**
 * Samples for Fund ServiceType
 */
$fund = new \ServiceType\Fund($options);
$fund->setSoapHeaderApiAuthentication(new \StructType\ApiAuthentication());
/**
 * Sample call for FundPaymentCard operation/method
 */
if ($fund->FundPaymentCard(new \StructType\FundPaymentCardRequest()) !== false) {
    print_r($fund->getResult());
} else {
    print_r($fund->getLastError());
}
