<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VolumeFilter StructType
 * @subpackage Structs
 */
class VolumeFilter extends AbstractStructBase
{
    /**
     * The VolumeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $VolumeID;
    /**
     * The Compare
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Compare;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Value;
    /**
     * Constructor method for VolumeFilter
     * @uses VolumeFilter::setVolumeID()
     * @uses VolumeFilter::setCompare()
     * @uses VolumeFilter::setValue()
     * @param int $volumeID
     * @param string $compare
     * @param float $value
     */
    public function __construct($volumeID = null, $compare = null, $value = null)
    {
        $this
            ->setVolumeID($volumeID)
            ->setCompare($compare)
            ->setValue($value);
    }
    /**
     * Get VolumeID value
     * @return int
     */
    public function getVolumeID()
    {
        return $this->VolumeID;
    }
    /**
     * Set VolumeID value
     * @param int $volumeID
     * @return \StructType\VolumeFilter
     */
    public function setVolumeID($volumeID = null)
    {
        // validation for constraint: int
        if (!is_null($volumeID) && !is_numeric($volumeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($volumeID)), __LINE__);
        }
        $this->VolumeID = $volumeID;
        return $this;
    }
    /**
     * Get Compare value
     * @return string
     */
    public function getCompare()
    {
        return $this->Compare;
    }
    /**
     * Set Compare value
     * @uses \EnumType\NumericCompareType::valueIsValid()
     * @uses \EnumType\NumericCompareType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $compare
     * @return \StructType\VolumeFilter
     */
    public function setCompare($compare = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\NumericCompareType::valueIsValid($compare)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $compare, implode(', ', \EnumType\NumericCompareType::getValidValues())), __LINE__);
        }
        $this->Compare = $compare;
        return $this;
    }
    /**
     * Get Value value
     * @return float
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \StructType\VolumeFilter
     */
    public function setValue($value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VolumeFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
