<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetItemWarehouseRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:SetItemWarehouseRequest
 * @subpackage Structs
 */
class SetItemWarehouseRequest extends ApiRequest
{
    /**
     * The WarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WarehouseID;
    /**
     * The IsAvailable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsAvailable;
    /**
     * The ItemManageTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ItemManageTypeID;
    /**
     * The AllowedUserWarehouses
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $AllowedUserWarehouses;
    /**
     * The AllowedWarehouseManagementTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $AllowedWarehouseManagementTypes;
    /**
     * The ItemCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemCode;
    /**
     * Constructor method for SetItemWarehouseRequest
     * @uses SetItemWarehouseRequest::setWarehouseID()
     * @uses SetItemWarehouseRequest::setIsAvailable()
     * @uses SetItemWarehouseRequest::setItemManageTypeID()
     * @uses SetItemWarehouseRequest::setAllowedUserWarehouses()
     * @uses SetItemWarehouseRequest::setAllowedWarehouseManagementTypes()
     * @uses SetItemWarehouseRequest::setItemCode()
     * @param int $warehouseID
     * @param bool $isAvailable
     * @param int $itemManageTypeID
     * @param \ArrayType\ArrayOfInt $allowedUserWarehouses
     * @param \ArrayType\ArrayOfInt $allowedWarehouseManagementTypes
     * @param string $itemCode
     */
    public function __construct($warehouseID = null, $isAvailable = null, $itemManageTypeID = null, \ArrayType\ArrayOfInt $allowedUserWarehouses = null, \ArrayType\ArrayOfInt $allowedWarehouseManagementTypes = null, $itemCode = null)
    {
        $this
            ->setWarehouseID($warehouseID)
            ->setIsAvailable($isAvailable)
            ->setItemManageTypeID($itemManageTypeID)
            ->setAllowedUserWarehouses($allowedUserWarehouses)
            ->setAllowedWarehouseManagementTypes($allowedWarehouseManagementTypes)
            ->setItemCode($itemCode);
    }
    /**
     * Get WarehouseID value
     * @return int
     */
    public function getWarehouseID()
    {
        return $this->WarehouseID;
    }
    /**
     * Set WarehouseID value
     * @param int $warehouseID
     * @return \StructType\SetItemWarehouseRequest
     */
    public function setWarehouseID($warehouseID = null)
    {
        // validation for constraint: int
        if (!is_null($warehouseID) && !is_numeric($warehouseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($warehouseID)), __LINE__);
        }
        $this->WarehouseID = $warehouseID;
        return $this;
    }
    /**
     * Get IsAvailable value
     * @return bool
     */
    public function getIsAvailable()
    {
        return $this->IsAvailable;
    }
    /**
     * Set IsAvailable value
     * @param bool $isAvailable
     * @return \StructType\SetItemWarehouseRequest
     */
    public function setIsAvailable($isAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailable) && !is_bool($isAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAvailable)), __LINE__);
        }
        $this->IsAvailable = $isAvailable;
        return $this;
    }
    /**
     * Get ItemManageTypeID value
     * @return int
     */
    public function getItemManageTypeID()
    {
        return $this->ItemManageTypeID;
    }
    /**
     * Set ItemManageTypeID value
     * @param int $itemManageTypeID
     * @return \StructType\SetItemWarehouseRequest
     */
    public function setItemManageTypeID($itemManageTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($itemManageTypeID) && !is_numeric($itemManageTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($itemManageTypeID)), __LINE__);
        }
        $this->ItemManageTypeID = $itemManageTypeID;
        return $this;
    }
    /**
     * Get AllowedUserWarehouses value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getAllowedUserWarehouses()
    {
        return $this->AllowedUserWarehouses;
    }
    /**
     * Set AllowedUserWarehouses value
     * @param \ArrayType\ArrayOfInt $allowedUserWarehouses
     * @return \StructType\SetItemWarehouseRequest
     */
    public function setAllowedUserWarehouses(\ArrayType\ArrayOfInt $allowedUserWarehouses = null)
    {
        $this->AllowedUserWarehouses = $allowedUserWarehouses;
        return $this;
    }
    /**
     * Get AllowedWarehouseManagementTypes value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getAllowedWarehouseManagementTypes()
    {
        return $this->AllowedWarehouseManagementTypes;
    }
    /**
     * Set AllowedWarehouseManagementTypes value
     * @param \ArrayType\ArrayOfInt $allowedWarehouseManagementTypes
     * @return \StructType\SetItemWarehouseRequest
     */
    public function setAllowedWarehouseManagementTypes(\ArrayType\ArrayOfInt $allowedWarehouseManagementTypes = null)
    {
        $this->AllowedWarehouseManagementTypes = $allowedWarehouseManagementTypes;
        return $this;
    }
    /**
     * Get ItemCode value
     * @return string|null
     */
    public function getItemCode()
    {
        return $this->ItemCode;
    }
    /**
     * Set ItemCode value
     * @param string $itemCode
     * @return \StructType\SetItemWarehouseRequest
     */
    public function setItemCode($itemCode = null)
    {
        // validation for constraint: string
        if (!is_null($itemCode) && !is_string($itemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemCode)), __LINE__);
        }
        $this->ItemCode = $itemCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetItemWarehouseRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
