<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetCustomerSocialNetworksRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:SetCustomerSocialNetworksRequest
 * @subpackage Structs
 */
class SetCustomerSocialNetworksRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The CustomerSocialNetworks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCustomerSocialNetworkRequest
     */
    public $CustomerSocialNetworks;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for SetCustomerSocialNetworksRequest
     * @uses SetCustomerSocialNetworksRequest::setCustomerID()
     * @uses SetCustomerSocialNetworksRequest::setCustomerSocialNetworks()
     * @uses SetCustomerSocialNetworksRequest::setCustomerKey()
     * @param int $customerID
     * @param \ArrayType\ArrayOfCustomerSocialNetworkRequest $customerSocialNetworks
     * @param string $customerKey
     */
    public function __construct($customerID = null, \ArrayType\ArrayOfCustomerSocialNetworkRequest $customerSocialNetworks = null, $customerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setCustomerSocialNetworks($customerSocialNetworks)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\SetCustomerSocialNetworksRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get CustomerSocialNetworks value
     * @return \ArrayType\ArrayOfCustomerSocialNetworkRequest|null
     */
    public function getCustomerSocialNetworks()
    {
        return $this->CustomerSocialNetworks;
    }
    /**
     * Set CustomerSocialNetworks value
     * @param \ArrayType\ArrayOfCustomerSocialNetworkRequest $customerSocialNetworks
     * @return \StructType\SetCustomerSocialNetworksRequest
     */
    public function setCustomerSocialNetworks(\ArrayType\ArrayOfCustomerSocialNetworkRequest $customerSocialNetworks = null)
    {
        $this->CustomerSocialNetworks = $customerSocialNetworks;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\SetCustomerSocialNetworksRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetCustomerSocialNetworksRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
