<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetCustomerSiteImageRequest StructType
 * @subpackage Structs
 */
class SetCustomerSiteImageRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The CustomerSiteImageType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CustomerSiteImageType;
    /**
     * The ImageName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ImageName;
    /**
     * The ImageData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ImageData;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for SetCustomerSiteImageRequest
     * @uses SetCustomerSiteImageRequest::setCustomerID()
     * @uses SetCustomerSiteImageRequest::setCustomerSiteImageType()
     * @uses SetCustomerSiteImageRequest::setImageName()
     * @uses SetCustomerSiteImageRequest::setImageData()
     * @uses SetCustomerSiteImageRequest::setCustomerKey()
     * @param int $customerID
     * @param string $customerSiteImageType
     * @param string $imageName
     * @param string $imageData
     * @param string $customerKey
     */
    public function __construct($customerID = null, $customerSiteImageType = null, $imageName = null, $imageData = null, $customerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setCustomerSiteImageType($customerSiteImageType)
            ->setImageName($imageName)
            ->setImageData($imageData)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\SetCustomerSiteImageRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get CustomerSiteImageType value
     * @return string
     */
    public function getCustomerSiteImageType()
    {
        return $this->CustomerSiteImageType;
    }
    /**
     * Set CustomerSiteImageType value
     * @uses \EnumType\CustomerSiteImageType::valueIsValid()
     * @uses \EnumType\CustomerSiteImageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $customerSiteImageType
     * @return \StructType\SetCustomerSiteImageRequest
     */
    public function setCustomerSiteImageType($customerSiteImageType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomerSiteImageType::valueIsValid($customerSiteImageType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $customerSiteImageType, implode(', ', \EnumType\CustomerSiteImageType::getValidValues())), __LINE__);
        }
        $this->CustomerSiteImageType = $customerSiteImageType;
        return $this;
    }
    /**
     * Get ImageName value
     * @return string|null
     */
    public function getImageName()
    {
        return $this->ImageName;
    }
    /**
     * Set ImageName value
     * @param string $imageName
     * @return \StructType\SetCustomerSiteImageRequest
     */
    public function setImageName($imageName = null)
    {
        // validation for constraint: string
        if (!is_null($imageName) && !is_string($imageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imageName)), __LINE__);
        }
        $this->ImageName = $imageName;
        return $this;
    }
    /**
     * Get ImageData value
     * @return string|null
     */
    public function getImageData()
    {
        return $this->ImageData;
    }
    /**
     * Set ImageData value
     * @param string $imageData
     * @return \StructType\SetCustomerSiteImageRequest
     */
    public function setImageData($imageData = null)
    {
        // validation for constraint: string
        if (!is_null($imageData) && !is_string($imageData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imageData)), __LINE__);
        }
        $this->ImageData = $imageData;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\SetCustomerSiteImageRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetCustomerSiteImageRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
