<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetAccountWalletRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:SetAccountWalletRequest
 * @subpackage Structs
 */
class SetAccountWalletRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The WalletAccountType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $WalletAccountType;
    /**
     * The WalletType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WalletType;
    /**
     * The WalletAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WalletAccount;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for SetAccountWalletRequest
     * @uses SetAccountWalletRequest::setCustomerID()
     * @uses SetAccountWalletRequest::setWalletAccountType()
     * @uses SetAccountWalletRequest::setWalletType()
     * @uses SetAccountWalletRequest::setWalletAccount()
     * @uses SetAccountWalletRequest::setCustomerKey()
     * @param int $customerID
     * @param string $walletAccountType
     * @param int $walletType
     * @param string $walletAccount
     * @param string $customerKey
     */
    public function __construct($customerID = null, $walletAccountType = null, $walletType = null, $walletAccount = null, $customerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setWalletAccountType($walletAccountType)
            ->setWalletType($walletType)
            ->setWalletAccount($walletAccount)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\SetAccountWalletRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get WalletAccountType value
     * @return string
     */
    public function getWalletAccountType()
    {
        return $this->WalletAccountType;
    }
    /**
     * Set WalletAccountType value
     * @uses \EnumType\AccountWalletType::valueIsValid()
     * @uses \EnumType\AccountWalletType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $walletAccountType
     * @return \StructType\SetAccountWalletRequest
     */
    public function setWalletAccountType($walletAccountType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountWalletType::valueIsValid($walletAccountType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $walletAccountType, implode(', ', \EnumType\AccountWalletType::getValidValues())), __LINE__);
        }
        $this->WalletAccountType = $walletAccountType;
        return $this;
    }
    /**
     * Get WalletType value
     * @return int
     */
    public function getWalletType()
    {
        return $this->WalletType;
    }
    /**
     * Set WalletType value
     * @param int $walletType
     * @return \StructType\SetAccountWalletRequest
     */
    public function setWalletType($walletType = null)
    {
        // validation for constraint: int
        if (!is_null($walletType) && !is_numeric($walletType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($walletType)), __LINE__);
        }
        $this->WalletType = $walletType;
        return $this;
    }
    /**
     * Get WalletAccount value
     * @return string|null
     */
    public function getWalletAccount()
    {
        return $this->WalletAccount;
    }
    /**
     * Set WalletAccount value
     * @param string $walletAccount
     * @return \StructType\SetAccountWalletRequest
     */
    public function setWalletAccount($walletAccount = null)
    {
        // validation for constraint: string
        if (!is_null($walletAccount) && !is_string($walletAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($walletAccount)), __LINE__);
        }
        $this->WalletAccount = $walletAccount;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\SetAccountWalletRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetAccountWalletRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
