<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetAccountCheckingRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:SetAccountCheckingRequest
 * @subpackage Structs
 */
class SetAccountCheckingRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The BankAccountType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BankAccountType;
    /**
     * The UseMainAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $UseMainAddress;
    /**
     * The BankAccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankAccountNumber;
    /**
     * The BankRoutingNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankRoutingNumber;
    /**
     * The BankName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankName;
    /**
     * The NameOnAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NameOnAccount;
    /**
     * The BillingAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingAddress;
    /**
     * The BillingCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingCity;
    /**
     * The BillingState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingState;
    /**
     * The BillingZip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingZip;
    /**
     * The BillingCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingCountry;
    /**
     * The DriversLicenseNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriversLicenseNumber;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for SetAccountCheckingRequest
     * @uses SetAccountCheckingRequest::setCustomerID()
     * @uses SetAccountCheckingRequest::setBankAccountType()
     * @uses SetAccountCheckingRequest::setUseMainAddress()
     * @uses SetAccountCheckingRequest::setBankAccountNumber()
     * @uses SetAccountCheckingRequest::setBankRoutingNumber()
     * @uses SetAccountCheckingRequest::setBankName()
     * @uses SetAccountCheckingRequest::setNameOnAccount()
     * @uses SetAccountCheckingRequest::setBillingAddress()
     * @uses SetAccountCheckingRequest::setBillingCity()
     * @uses SetAccountCheckingRequest::setBillingState()
     * @uses SetAccountCheckingRequest::setBillingZip()
     * @uses SetAccountCheckingRequest::setBillingCountry()
     * @uses SetAccountCheckingRequest::setDriversLicenseNumber()
     * @uses SetAccountCheckingRequest::setCustomerKey()
     * @param int $customerID
     * @param string $bankAccountType
     * @param bool $useMainAddress
     * @param string $bankAccountNumber
     * @param string $bankRoutingNumber
     * @param string $bankName
     * @param string $nameOnAccount
     * @param string $billingAddress
     * @param string $billingCity
     * @param string $billingState
     * @param string $billingZip
     * @param string $billingCountry
     * @param string $driversLicenseNumber
     * @param string $customerKey
     */
    public function __construct($customerID = null, $bankAccountType = null, $useMainAddress = null, $bankAccountNumber = null, $bankRoutingNumber = null, $bankName = null, $nameOnAccount = null, $billingAddress = null, $billingCity = null, $billingState = null, $billingZip = null, $billingCountry = null, $driversLicenseNumber = null, $customerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setBankAccountType($bankAccountType)
            ->setUseMainAddress($useMainAddress)
            ->setBankAccountNumber($bankAccountNumber)
            ->setBankRoutingNumber($bankRoutingNumber)
            ->setBankName($bankName)
            ->setNameOnAccount($nameOnAccount)
            ->setBillingAddress($billingAddress)
            ->setBillingCity($billingCity)
            ->setBillingState($billingState)
            ->setBillingZip($billingZip)
            ->setBillingCountry($billingCountry)
            ->setDriversLicenseNumber($driversLicenseNumber)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\SetAccountCheckingRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get BankAccountType value
     * @return string
     */
    public function getBankAccountType()
    {
        return $this->BankAccountType;
    }
    /**
     * Set BankAccountType value
     * @uses \EnumType\BankAccountType::valueIsValid()
     * @uses \EnumType\BankAccountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bankAccountType
     * @return \StructType\SetAccountCheckingRequest
     */
    public function setBankAccountType($bankAccountType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BankAccountType::valueIsValid($bankAccountType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $bankAccountType, implode(', ', \EnumType\BankAccountType::getValidValues())), __LINE__);
        }
        $this->BankAccountType = $bankAccountType;
        return $this;
    }
    /**
     * Get UseMainAddress value
     * @return bool
     */
    public function getUseMainAddress()
    {
        return $this->UseMainAddress;
    }
    /**
     * Set UseMainAddress value
     * @param bool $useMainAddress
     * @return \StructType\SetAccountCheckingRequest
     */
    public function setUseMainAddress($useMainAddress = null)
    {
        // validation for constraint: boolean
        if (!is_null($useMainAddress) && !is_bool($useMainAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($useMainAddress)), __LINE__);
        }
        $this->UseMainAddress = $useMainAddress;
        return $this;
    }
    /**
     * Get BankAccountNumber value
     * @return string|null
     */
    public function getBankAccountNumber()
    {
        return $this->BankAccountNumber;
    }
    /**
     * Set BankAccountNumber value
     * @param string $bankAccountNumber
     * @return \StructType\SetAccountCheckingRequest
     */
    public function setBankAccountNumber($bankAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccountNumber) && !is_string($bankAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankAccountNumber)), __LINE__);
        }
        $this->BankAccountNumber = $bankAccountNumber;
        return $this;
    }
    /**
     * Get BankRoutingNumber value
     * @return string|null
     */
    public function getBankRoutingNumber()
    {
        return $this->BankRoutingNumber;
    }
    /**
     * Set BankRoutingNumber value
     * @param string $bankRoutingNumber
     * @return \StructType\SetAccountCheckingRequest
     */
    public function setBankRoutingNumber($bankRoutingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bankRoutingNumber) && !is_string($bankRoutingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankRoutingNumber)), __LINE__);
        }
        $this->BankRoutingNumber = $bankRoutingNumber;
        return $this;
    }
    /**
     * Get BankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->BankName;
    }
    /**
     * Set BankName value
     * @param string $bankName
     * @return \StructType\SetAccountCheckingRequest
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankName)), __LINE__);
        }
        $this->BankName = $bankName;
        return $this;
    }
    /**
     * Get NameOnAccount value
     * @return string|null
     */
    public function getNameOnAccount()
    {
        return $this->NameOnAccount;
    }
    /**
     * Set NameOnAccount value
     * @param string $nameOnAccount
     * @return \StructType\SetAccountCheckingRequest
     */
    public function setNameOnAccount($nameOnAccount = null)
    {
        // validation for constraint: string
        if (!is_null($nameOnAccount) && !is_string($nameOnAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameOnAccount)), __LINE__);
        }
        $this->NameOnAccount = $nameOnAccount;
        return $this;
    }
    /**
     * Get BillingAddress value
     * @return string|null
     */
    public function getBillingAddress()
    {
        return $this->BillingAddress;
    }
    /**
     * Set BillingAddress value
     * @param string $billingAddress
     * @return \StructType\SetAccountCheckingRequest
     */
    public function setBillingAddress($billingAddress = null)
    {
        // validation for constraint: string
        if (!is_null($billingAddress) && !is_string($billingAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingAddress)), __LINE__);
        }
        $this->BillingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get BillingCity value
     * @return string|null
     */
    public function getBillingCity()
    {
        return $this->BillingCity;
    }
    /**
     * Set BillingCity value
     * @param string $billingCity
     * @return \StructType\SetAccountCheckingRequest
     */
    public function setBillingCity($billingCity = null)
    {
        // validation for constraint: string
        if (!is_null($billingCity) && !is_string($billingCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingCity)), __LINE__);
        }
        $this->BillingCity = $billingCity;
        return $this;
    }
    /**
     * Get BillingState value
     * @return string|null
     */
    public function getBillingState()
    {
        return $this->BillingState;
    }
    /**
     * Set BillingState value
     * @param string $billingState
     * @return \StructType\SetAccountCheckingRequest
     */
    public function setBillingState($billingState = null)
    {
        // validation for constraint: string
        if (!is_null($billingState) && !is_string($billingState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingState)), __LINE__);
        }
        $this->BillingState = $billingState;
        return $this;
    }
    /**
     * Get BillingZip value
     * @return string|null
     */
    public function getBillingZip()
    {
        return $this->BillingZip;
    }
    /**
     * Set BillingZip value
     * @param string $billingZip
     * @return \StructType\SetAccountCheckingRequest
     */
    public function setBillingZip($billingZip = null)
    {
        // validation for constraint: string
        if (!is_null($billingZip) && !is_string($billingZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingZip)), __LINE__);
        }
        $this->BillingZip = $billingZip;
        return $this;
    }
    /**
     * Get BillingCountry value
     * @return string|null
     */
    public function getBillingCountry()
    {
        return $this->BillingCountry;
    }
    /**
     * Set BillingCountry value
     * @param string $billingCountry
     * @return \StructType\SetAccountCheckingRequest
     */
    public function setBillingCountry($billingCountry = null)
    {
        // validation for constraint: string
        if (!is_null($billingCountry) && !is_string($billingCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingCountry)), __LINE__);
        }
        $this->BillingCountry = $billingCountry;
        return $this;
    }
    /**
     * Get DriversLicenseNumber value
     * @return string|null
     */
    public function getDriversLicenseNumber()
    {
        return $this->DriversLicenseNumber;
    }
    /**
     * Set DriversLicenseNumber value
     * @param string $driversLicenseNumber
     * @return \StructType\SetAccountCheckingRequest
     */
    public function setDriversLicenseNumber($driversLicenseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($driversLicenseNumber) && !is_string($driversLicenseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($driversLicenseNumber)), __LINE__);
        }
        $this->DriversLicenseNumber = $driversLicenseNumber;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\SetAccountCheckingRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetAccountCheckingRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
