<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Schema StructType
 * @subpackage Structs
 */
class Schema extends AbstractStructBase
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Entities
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEntity
     */
    public $Entities;
    /**
     * Constructor method for Schema
     * @uses Schema::setName()
     * @uses Schema::setEntities()
     * @param string $name
     * @param \ArrayType\ArrayOfEntity $entities
     */
    public function __construct($name = null, \ArrayType\ArrayOfEntity $entities = null)
    {
        $this
            ->setName($name)
            ->setEntities($entities);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Schema
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Entities value
     * @return \ArrayType\ArrayOfEntity|null
     */
    public function getEntities()
    {
        return $this->Entities;
    }
    /**
     * Set Entities value
     * @param \ArrayType\ArrayOfEntity $entities
     * @return \StructType\Schema
     */
    public function setEntities(\ArrayType\ArrayOfEntity $entities = null)
    {
        $this->Entities = $entities;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Schema
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
