<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegionResponse StructType
 * @subpackage Structs
 */
class RegionResponse extends AbstractStructBase
{
    /**
     * The RegionCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RegionCode;
    /**
     * The RegionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RegionName;
    /**
     * Constructor method for RegionResponse
     * @uses RegionResponse::setRegionCode()
     * @uses RegionResponse::setRegionName()
     * @param string $regionCode
     * @param string $regionName
     */
    public function __construct($regionCode = null, $regionName = null)
    {
        $this
            ->setRegionCode($regionCode)
            ->setRegionName($regionName);
    }
    /**
     * Get RegionCode value
     * @return string|null
     */
    public function getRegionCode()
    {
        return $this->RegionCode;
    }
    /**
     * Set RegionCode value
     * @param string $regionCode
     * @return \StructType\RegionResponse
     */
    public function setRegionCode($regionCode = null)
    {
        // validation for constraint: string
        if (!is_null($regionCode) && !is_string($regionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regionCode)), __LINE__);
        }
        $this->RegionCode = $regionCode;
        return $this;
    }
    /**
     * Get RegionName value
     * @return string|null
     */
    public function getRegionName()
    {
        return $this->RegionName;
    }
    /**
     * Set RegionName value
     * @param string $regionName
     * @return \StructType\RegionResponse
     */
    public function setRegionName($regionName = null)
    {
        // validation for constraint: string
        if (!is_null($regionName) && !is_string($regionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regionName)), __LINE__);
        }
        $this->RegionName = $regionName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RegionResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
