<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlaceBinaryNodeRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:PlaceBinaryNodeRequest
 * @subpackage Structs
 */
class PlaceBinaryNodeRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The ToParentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ToParentID;
    /**
     * The PlacementType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PlacementType;
    /**
     * The Reason
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reason;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * The ToParentKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ToParentKey;
    /**
     * Constructor method for PlaceBinaryNodeRequest
     * @uses PlaceBinaryNodeRequest::setCustomerID()
     * @uses PlaceBinaryNodeRequest::setToParentID()
     * @uses PlaceBinaryNodeRequest::setPlacementType()
     * @uses PlaceBinaryNodeRequest::setReason()
     * @uses PlaceBinaryNodeRequest::setCustomerKey()
     * @uses PlaceBinaryNodeRequest::setToParentKey()
     * @param int $customerID
     * @param int $toParentID
     * @param string $placementType
     * @param string $reason
     * @param string $customerKey
     * @param string $toParentKey
     */
    public function __construct($customerID = null, $toParentID = null, $placementType = null, $reason = null, $customerKey = null, $toParentKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setToParentID($toParentID)
            ->setPlacementType($placementType)
            ->setReason($reason)
            ->setCustomerKey($customerKey)
            ->setToParentKey($toParentKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\PlaceBinaryNodeRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get ToParentID value
     * @return int
     */
    public function getToParentID()
    {
        return $this->ToParentID;
    }
    /**
     * Set ToParentID value
     * @param int $toParentID
     * @return \StructType\PlaceBinaryNodeRequest
     */
    public function setToParentID($toParentID = null)
    {
        // validation for constraint: int
        if (!is_null($toParentID) && !is_numeric($toParentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($toParentID)), __LINE__);
        }
        $this->ToParentID = $toParentID;
        return $this;
    }
    /**
     * Get PlacementType value
     * @return string
     */
    public function getPlacementType()
    {
        return $this->PlacementType;
    }
    /**
     * Set PlacementType value
     * @uses \EnumType\BinaryPlacementType::valueIsValid()
     * @uses \EnumType\BinaryPlacementType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $placementType
     * @return \StructType\PlaceBinaryNodeRequest
     */
    public function setPlacementType($placementType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BinaryPlacementType::valueIsValid($placementType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $placementType, implode(', ', \EnumType\BinaryPlacementType::getValidValues())), __LINE__);
        }
        $this->PlacementType = $placementType;
        return $this;
    }
    /**
     * Get Reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @param string $reason
     * @return \StructType\PlaceBinaryNodeRequest
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reason)), __LINE__);
        }
        $this->Reason = $reason;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\PlaceBinaryNodeRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Get ToParentKey value
     * @return string|null
     */
    public function getToParentKey()
    {
        return $this->ToParentKey;
    }
    /**
     * Set ToParentKey value
     * @param string $toParentKey
     * @return \StructType\PlaceBinaryNodeRequest
     */
    public function setToParentKey($toParentKey = null)
    {
        // validation for constraint: string
        if (!is_null($toParentKey) && !is_string($toParentKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toParentKey)), __LINE__);
        }
        $this->ToParentKey = $toParentKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlaceBinaryNodeRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
