<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParameterRequest StructType
 * @subpackage Structs
 */
class ParameterRequest extends AbstractStructBase
{
    /**
     * The ParameterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ParameterName;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var mixed
     */
    public $Value;
    /**
     * Constructor method for ParameterRequest
     * @uses ParameterRequest::setParameterName()
     * @uses ParameterRequest::setValue()
     * @param string $parameterName
     * @param mixed $value
     */
    public function __construct($parameterName = null, $value = null)
    {
        $this
            ->setParameterName($parameterName)
            ->setValue($value);
    }
    /**
     * Get ParameterName value
     * @return string|null
     */
    public function getParameterName()
    {
        return $this->ParameterName;
    }
    /**
     * Set ParameterName value
     * @param string $parameterName
     * @return \StructType\ParameterRequest
     */
    public function setParameterName($parameterName = null)
    {
        // validation for constraint: string
        if (!is_null($parameterName) && !is_string($parameterName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parameterName)), __LINE__);
        }
        $this->ParameterName = $parameterName;
        return $this;
    }
    /**
     * Get Value value
     * @return mixed|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param mixed $value
     * @return \StructType\ParameterRequest
     */
    public function setValue($value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ParameterRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
