<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MoveEmailRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:MoveEmailRequest
 * @subpackage Structs
 */
class MoveEmailRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The MailID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MailID;
    /**
     * The ToMailFolderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ToMailFolderID;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for MoveEmailRequest
     * @uses MoveEmailRequest::setCustomerID()
     * @uses MoveEmailRequest::setMailID()
     * @uses MoveEmailRequest::setToMailFolderID()
     * @uses MoveEmailRequest::setCustomerKey()
     * @param int $customerID
     * @param int $mailID
     * @param int $toMailFolderID
     * @param string $customerKey
     */
    public function __construct($customerID = null, $mailID = null, $toMailFolderID = null, $customerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setMailID($mailID)
            ->setToMailFolderID($toMailFolderID)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\MoveEmailRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get MailID value
     * @return int
     */
    public function getMailID()
    {
        return $this->MailID;
    }
    /**
     * Set MailID value
     * @param int $mailID
     * @return \StructType\MoveEmailRequest
     */
    public function setMailID($mailID = null)
    {
        // validation for constraint: int
        if (!is_null($mailID) && !is_numeric($mailID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($mailID)), __LINE__);
        }
        $this->MailID = $mailID;
        return $this;
    }
    /**
     * Get ToMailFolderID value
     * @return int
     */
    public function getToMailFolderID()
    {
        return $this->ToMailFolderID;
    }
    /**
     * Set ToMailFolderID value
     * @param int $toMailFolderID
     * @return \StructType\MoveEmailRequest
     */
    public function setToMailFolderID($toMailFolderID = null)
    {
        // validation for constraint: int
        if (!is_null($toMailFolderID) && !is_numeric($toMailFolderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($toMailFolderID)), __LINE__);
        }
        $this->ToMailFolderID = $toMailFolderID;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\MoveEmailRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MoveEmailRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
