<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LanguageResponse StructType
 * @subpackage Structs
 */
class LanguageResponse extends AbstractStructBase
{
    /**
     * The LanguageID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LanguageID;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The CultureCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CultureCode;
    /**
     * Constructor method for LanguageResponse
     * @uses LanguageResponse::setLanguageID()
     * @uses LanguageResponse::setDescription()
     * @uses LanguageResponse::setCultureCode()
     * @param int $languageID
     * @param string $description
     * @param string $cultureCode
     */
    public function __construct($languageID = null, $description = null, $cultureCode = null)
    {
        $this
            ->setLanguageID($languageID)
            ->setDescription($description)
            ->setCultureCode($cultureCode);
    }
    /**
     * Get LanguageID value
     * @return int
     */
    public function getLanguageID()
    {
        return $this->LanguageID;
    }
    /**
     * Set LanguageID value
     * @param int $languageID
     * @return \StructType\LanguageResponse
     */
    public function setLanguageID($languageID = null)
    {
        // validation for constraint: int
        if (!is_null($languageID) && !is_numeric($languageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($languageID)), __LINE__);
        }
        $this->LanguageID = $languageID;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\LanguageResponse
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get CultureCode value
     * @return string|null
     */
    public function getCultureCode()
    {
        return $this->CultureCode;
    }
    /**
     * Set CultureCode value
     * @param string $cultureCode
     * @return \StructType\LanguageResponse
     */
    public function setCultureCode($cultureCode = null)
    {
        // validation for constraint: string
        if (!is_null($cultureCode) && !is_string($cultureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cultureCode)), __LINE__);
        }
        $this->CultureCode = $cultureCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LanguageResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
