<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemCountryRegionResponse StructType
 * @subpackage Structs
 */
class ItemCountryRegionResponse extends AbstractStructBase
{
    /**
     * The Taxed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Taxed;
    /**
     * The TaxedFed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $TaxedFed;
    /**
     * The TaxedState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $TaxedState;
    /**
     * The UseTaxOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $UseTaxOverride;
    /**
     * The TaxOverridePct
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TaxOverridePct;
    /**
     * The ItemCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemCode;
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * The RegionCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RegionCode;
    /**
     * Constructor method for ItemCountryRegionResponse
     * @uses ItemCountryRegionResponse::setTaxed()
     * @uses ItemCountryRegionResponse::setTaxedFed()
     * @uses ItemCountryRegionResponse::setTaxedState()
     * @uses ItemCountryRegionResponse::setUseTaxOverride()
     * @uses ItemCountryRegionResponse::setTaxOverridePct()
     * @uses ItemCountryRegionResponse::setItemCode()
     * @uses ItemCountryRegionResponse::setCountryCode()
     * @uses ItemCountryRegionResponse::setRegionCode()
     * @param bool $taxed
     * @param bool $taxedFed
     * @param bool $taxedState
     * @param bool $useTaxOverride
     * @param float $taxOverridePct
     * @param string $itemCode
     * @param string $countryCode
     * @param string $regionCode
     */
    public function __construct($taxed = null, $taxedFed = null, $taxedState = null, $useTaxOverride = null, $taxOverridePct = null, $itemCode = null, $countryCode = null, $regionCode = null)
    {
        $this
            ->setTaxed($taxed)
            ->setTaxedFed($taxedFed)
            ->setTaxedState($taxedState)
            ->setUseTaxOverride($useTaxOverride)
            ->setTaxOverridePct($taxOverridePct)
            ->setItemCode($itemCode)
            ->setCountryCode($countryCode)
            ->setRegionCode($regionCode);
    }
    /**
     * Get Taxed value
     * @return bool
     */
    public function getTaxed()
    {
        return $this->Taxed;
    }
    /**
     * Set Taxed value
     * @param bool $taxed
     * @return \StructType\ItemCountryRegionResponse
     */
    public function setTaxed($taxed = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxed) && !is_bool($taxed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($taxed)), __LINE__);
        }
        $this->Taxed = $taxed;
        return $this;
    }
    /**
     * Get TaxedFed value
     * @return bool
     */
    public function getTaxedFed()
    {
        return $this->TaxedFed;
    }
    /**
     * Set TaxedFed value
     * @param bool $taxedFed
     * @return \StructType\ItemCountryRegionResponse
     */
    public function setTaxedFed($taxedFed = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxedFed) && !is_bool($taxedFed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($taxedFed)), __LINE__);
        }
        $this->TaxedFed = $taxedFed;
        return $this;
    }
    /**
     * Get TaxedState value
     * @return bool
     */
    public function getTaxedState()
    {
        return $this->TaxedState;
    }
    /**
     * Set TaxedState value
     * @param bool $taxedState
     * @return \StructType\ItemCountryRegionResponse
     */
    public function setTaxedState($taxedState = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxedState) && !is_bool($taxedState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($taxedState)), __LINE__);
        }
        $this->TaxedState = $taxedState;
        return $this;
    }
    /**
     * Get UseTaxOverride value
     * @return bool
     */
    public function getUseTaxOverride()
    {
        return $this->UseTaxOverride;
    }
    /**
     * Set UseTaxOverride value
     * @param bool $useTaxOverride
     * @return \StructType\ItemCountryRegionResponse
     */
    public function setUseTaxOverride($useTaxOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($useTaxOverride) && !is_bool($useTaxOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($useTaxOverride)), __LINE__);
        }
        $this->UseTaxOverride = $useTaxOverride;
        return $this;
    }
    /**
     * Get TaxOverridePct value
     * @return float
     */
    public function getTaxOverridePct()
    {
        return $this->TaxOverridePct;
    }
    /**
     * Set TaxOverridePct value
     * @param float $taxOverridePct
     * @return \StructType\ItemCountryRegionResponse
     */
    public function setTaxOverridePct($taxOverridePct = null)
    {
        $this->TaxOverridePct = $taxOverridePct;
        return $this;
    }
    /**
     * Get ItemCode value
     * @return string|null
     */
    public function getItemCode()
    {
        return $this->ItemCode;
    }
    /**
     * Set ItemCode value
     * @param string $itemCode
     * @return \StructType\ItemCountryRegionResponse
     */
    public function setItemCode($itemCode = null)
    {
        // validation for constraint: string
        if (!is_null($itemCode) && !is_string($itemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemCode)), __LINE__);
        }
        $this->ItemCode = $itemCode;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\ItemCountryRegionResponse
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get RegionCode value
     * @return string|null
     */
    public function getRegionCode()
    {
        return $this->RegionCode;
    }
    /**
     * Set RegionCode value
     * @param string $regionCode
     * @return \StructType\ItemCountryRegionResponse
     */
    public function setRegionCode($regionCode = null)
    {
        // validation for constraint: string
        if (!is_null($regionCode) && !is_string($regionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regionCode)), __LINE__);
        }
        $this->RegionCode = $regionCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemCountryRegionResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
