<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IsMatrixChildValidateRequest StructType
 * @subpackage Structs
 */
class IsMatrixChildValidateRequest extends ValidateRequest
{
    /**
     * The ParentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ParentID;
    /**
     * The ChildID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChildID;
    /**
     * Constructor method for IsMatrixChildValidateRequest
     * @uses IsMatrixChildValidateRequest::setParentID()
     * @uses IsMatrixChildValidateRequest::setChildID()
     * @param int $parentID
     * @param int $childID
     */
    public function __construct($parentID = null, $childID = null)
    {
        $this
            ->setParentID($parentID)
            ->setChildID($childID);
    }
    /**
     * Get ParentID value
     * @return int
     */
    public function getParentID()
    {
        return $this->ParentID;
    }
    /**
     * Set ParentID value
     * @param int $parentID
     * @return \StructType\IsMatrixChildValidateRequest
     */
    public function setParentID($parentID = null)
    {
        // validation for constraint: int
        if (!is_null($parentID) && !is_numeric($parentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($parentID)), __LINE__);
        }
        $this->ParentID = $parentID;
        return $this;
    }
    /**
     * Get ChildID value
     * @return int
     */
    public function getChildID()
    {
        return $this->ChildID;
    }
    /**
     * Set ChildID value
     * @param int $childID
     * @return \StructType\IsMatrixChildValidateRequest
     */
    public function setChildID($childID = null)
    {
        // validation for constraint: int
        if (!is_null($childID) && !is_numeric($childID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($childID)), __LINE__);
        }
        $this->ChildID = $childID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IsMatrixChildValidateRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
