<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetQualificationOverridesRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetQualificationOverridesRequest
 * @subpackage Structs
 */
class GetQualificationOverridesRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CustomerID;
    /**
     * The OverrideID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $OverrideID;
    /**
     * The BatchSize
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BatchSize;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for GetQualificationOverridesRequest
     * @uses GetQualificationOverridesRequest::setCustomerID()
     * @uses GetQualificationOverridesRequest::setOverrideID()
     * @uses GetQualificationOverridesRequest::setBatchSize()
     * @uses GetQualificationOverridesRequest::setCustomerKey()
     * @param int $customerID
     * @param int $overrideID
     * @param int $batchSize
     * @param string $customerKey
     */
    public function __construct($customerID = null, $overrideID = null, $batchSize = null, $customerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setOverrideID($overrideID)
            ->setBatchSize($batchSize)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\GetQualificationOverridesRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get OverrideID value
     * @return int
     */
    public function getOverrideID()
    {
        return $this->OverrideID;
    }
    /**
     * Set OverrideID value
     * @param int $overrideID
     * @return \StructType\GetQualificationOverridesRequest
     */
    public function setOverrideID($overrideID = null)
    {
        // validation for constraint: int
        if (!is_null($overrideID) && !is_numeric($overrideID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($overrideID)), __LINE__);
        }
        $this->OverrideID = $overrideID;
        return $this;
    }
    /**
     * Get BatchSize value
     * @return int
     */
    public function getBatchSize()
    {
        return $this->BatchSize;
    }
    /**
     * Set BatchSize value
     * @param int $batchSize
     * @return \StructType\GetQualificationOverridesRequest
     */
    public function setBatchSize($batchSize = null)
    {
        // validation for constraint: int
        if (!is_null($batchSize) && !is_numeric($batchSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($batchSize)), __LINE__);
        }
        $this->BatchSize = $batchSize;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\GetQualificationOverridesRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetQualificationOverridesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
