<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetQualificationOverrideResponse StructType
 * @subpackage Structs
 */
class GetQualificationOverrideResponse extends AbstractStructBase
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The OverrideID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OverrideID;
    /**
     * The Qualifies
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Qualifies;
    /**
     * The PeriodType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PeriodType;
    /**
     * The StartPeriodID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $StartPeriodID;
    /**
     * The EndPeriodID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $EndPeriodID;
    /**
     * The ModifiedDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ModifiedDate;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The ModifiedBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ModifiedBy;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for GetQualificationOverrideResponse
     * @uses GetQualificationOverrideResponse::setCustomerID()
     * @uses GetQualificationOverrideResponse::setOverrideID()
     * @uses GetQualificationOverrideResponse::setQualifies()
     * @uses GetQualificationOverrideResponse::setPeriodType()
     * @uses GetQualificationOverrideResponse::setStartPeriodID()
     * @uses GetQualificationOverrideResponse::setEndPeriodID()
     * @uses GetQualificationOverrideResponse::setModifiedDate()
     * @uses GetQualificationOverrideResponse::setAmount()
     * @uses GetQualificationOverrideResponse::setModifiedBy()
     * @uses GetQualificationOverrideResponse::setCustomerKey()
     * @param int $customerID
     * @param int $overrideID
     * @param bool $qualifies
     * @param int $periodType
     * @param int $startPeriodID
     * @param int $endPeriodID
     * @param string $modifiedDate
     * @param float $amount
     * @param string $modifiedBy
     * @param string $customerKey
     */
    public function __construct($customerID = null, $overrideID = null, $qualifies = null, $periodType = null, $startPeriodID = null, $endPeriodID = null, $modifiedDate = null, $amount = null, $modifiedBy = null, $customerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setOverrideID($overrideID)
            ->setQualifies($qualifies)
            ->setPeriodType($periodType)
            ->setStartPeriodID($startPeriodID)
            ->setEndPeriodID($endPeriodID)
            ->setModifiedDate($modifiedDate)
            ->setAmount($amount)
            ->setModifiedBy($modifiedBy)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\GetQualificationOverrideResponse
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get OverrideID value
     * @return int
     */
    public function getOverrideID()
    {
        return $this->OverrideID;
    }
    /**
     * Set OverrideID value
     * @param int $overrideID
     * @return \StructType\GetQualificationOverrideResponse
     */
    public function setOverrideID($overrideID = null)
    {
        // validation for constraint: int
        if (!is_null($overrideID) && !is_numeric($overrideID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($overrideID)), __LINE__);
        }
        $this->OverrideID = $overrideID;
        return $this;
    }
    /**
     * Get Qualifies value
     * @return bool
     */
    public function getQualifies()
    {
        return $this->Qualifies;
    }
    /**
     * Set Qualifies value
     * @param bool $qualifies
     * @return \StructType\GetQualificationOverrideResponse
     */
    public function setQualifies($qualifies = null)
    {
        // validation for constraint: boolean
        if (!is_null($qualifies) && !is_bool($qualifies)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($qualifies)), __LINE__);
        }
        $this->Qualifies = $qualifies;
        return $this;
    }
    /**
     * Get PeriodType value
     * @return int
     */
    public function getPeriodType()
    {
        return $this->PeriodType;
    }
    /**
     * Set PeriodType value
     * @param int $periodType
     * @return \StructType\GetQualificationOverrideResponse
     */
    public function setPeriodType($periodType = null)
    {
        // validation for constraint: int
        if (!is_null($periodType) && !is_numeric($periodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($periodType)), __LINE__);
        }
        $this->PeriodType = $periodType;
        return $this;
    }
    /**
     * Get StartPeriodID value
     * @return int
     */
    public function getStartPeriodID()
    {
        return $this->StartPeriodID;
    }
    /**
     * Set StartPeriodID value
     * @param int $startPeriodID
     * @return \StructType\GetQualificationOverrideResponse
     */
    public function setStartPeriodID($startPeriodID = null)
    {
        // validation for constraint: int
        if (!is_null($startPeriodID) && !is_numeric($startPeriodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($startPeriodID)), __LINE__);
        }
        $this->StartPeriodID = $startPeriodID;
        return $this;
    }
    /**
     * Get EndPeriodID value
     * @return int
     */
    public function getEndPeriodID()
    {
        return $this->EndPeriodID;
    }
    /**
     * Set EndPeriodID value
     * @param int $endPeriodID
     * @return \StructType\GetQualificationOverrideResponse
     */
    public function setEndPeriodID($endPeriodID = null)
    {
        // validation for constraint: int
        if (!is_null($endPeriodID) && !is_numeric($endPeriodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($endPeriodID)), __LINE__);
        }
        $this->EndPeriodID = $endPeriodID;
        return $this;
    }
    /**
     * Get ModifiedDate value
     * @return string
     */
    public function getModifiedDate()
    {
        return $this->ModifiedDate;
    }
    /**
     * Set ModifiedDate value
     * @param string $modifiedDate
     * @return \StructType\GetQualificationOverrideResponse
     */
    public function setModifiedDate($modifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedDate) && !is_string($modifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modifiedDate)), __LINE__);
        }
        $this->ModifiedDate = $modifiedDate;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\GetQualificationOverrideResponse
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ModifiedBy value
     * @return string|null
     */
    public function getModifiedBy()
    {
        return $this->ModifiedBy;
    }
    /**
     * Set ModifiedBy value
     * @param string $modifiedBy
     * @return \StructType\GetQualificationOverrideResponse
     */
    public function setModifiedBy($modifiedBy = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedBy) && !is_string($modifiedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modifiedBy)), __LINE__);
        }
        $this->ModifiedBy = $modifiedBy;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\GetQualificationOverrideResponse
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetQualificationOverrideResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
