<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPartiesRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetPartiesRequest
 * @subpackage Structs
 */
class GetPartiesRequest extends ApiRequest
{
    /**
     * The PartyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PartyID;
    /**
     * The HostID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $HostID;
    /**
     * The DistributorID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DistributorID;
    /**
     * The PartyStatusType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PartyStatusType;
    /**
     * The BookingPartyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BookingPartyID;
    /**
     * The Field1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field1;
    /**
     * The Field2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field2;
    /**
     * The Field3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field3;
    /**
     * The Field4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field4;
    /**
     * The Field5
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field5;
    /**
     * Constructor method for GetPartiesRequest
     * @uses GetPartiesRequest::setPartyID()
     * @uses GetPartiesRequest::setHostID()
     * @uses GetPartiesRequest::setDistributorID()
     * @uses GetPartiesRequest::setPartyStatusType()
     * @uses GetPartiesRequest::setBookingPartyID()
     * @uses GetPartiesRequest::setField1()
     * @uses GetPartiesRequest::setField2()
     * @uses GetPartiesRequest::setField3()
     * @uses GetPartiesRequest::setField4()
     * @uses GetPartiesRequest::setField5()
     * @param int $partyID
     * @param int $hostID
     * @param int $distributorID
     * @param int $partyStatusType
     * @param int $bookingPartyID
     * @param string $field1
     * @param string $field2
     * @param string $field3
     * @param string $field4
     * @param string $field5
     */
    public function __construct($partyID = null, $hostID = null, $distributorID = null, $partyStatusType = null, $bookingPartyID = null, $field1 = null, $field2 = null, $field3 = null, $field4 = null, $field5 = null)
    {
        $this
            ->setPartyID($partyID)
            ->setHostID($hostID)
            ->setDistributorID($distributorID)
            ->setPartyStatusType($partyStatusType)
            ->setBookingPartyID($bookingPartyID)
            ->setField1($field1)
            ->setField2($field2)
            ->setField3($field3)
            ->setField4($field4)
            ->setField5($field5);
    }
    /**
     * Get PartyID value
     * @return int
     */
    public function getPartyID()
    {
        return $this->PartyID;
    }
    /**
     * Set PartyID value
     * @param int $partyID
     * @return \StructType\GetPartiesRequest
     */
    public function setPartyID($partyID = null)
    {
        // validation for constraint: int
        if (!is_null($partyID) && !is_numeric($partyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($partyID)), __LINE__);
        }
        $this->PartyID = $partyID;
        return $this;
    }
    /**
     * Get HostID value
     * @return int
     */
    public function getHostID()
    {
        return $this->HostID;
    }
    /**
     * Set HostID value
     * @param int $hostID
     * @return \StructType\GetPartiesRequest
     */
    public function setHostID($hostID = null)
    {
        // validation for constraint: int
        if (!is_null($hostID) && !is_numeric($hostID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hostID)), __LINE__);
        }
        $this->HostID = $hostID;
        return $this;
    }
    /**
     * Get DistributorID value
     * @return int
     */
    public function getDistributorID()
    {
        return $this->DistributorID;
    }
    /**
     * Set DistributorID value
     * @param int $distributorID
     * @return \StructType\GetPartiesRequest
     */
    public function setDistributorID($distributorID = null)
    {
        // validation for constraint: int
        if (!is_null($distributorID) && !is_numeric($distributorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributorID)), __LINE__);
        }
        $this->DistributorID = $distributorID;
        return $this;
    }
    /**
     * Get PartyStatusType value
     * @return int
     */
    public function getPartyStatusType()
    {
        return $this->PartyStatusType;
    }
    /**
     * Set PartyStatusType value
     * @param int $partyStatusType
     * @return \StructType\GetPartiesRequest
     */
    public function setPartyStatusType($partyStatusType = null)
    {
        // validation for constraint: int
        if (!is_null($partyStatusType) && !is_numeric($partyStatusType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($partyStatusType)), __LINE__);
        }
        $this->PartyStatusType = $partyStatusType;
        return $this;
    }
    /**
     * Get BookingPartyID value
     * @return int
     */
    public function getBookingPartyID()
    {
        return $this->BookingPartyID;
    }
    /**
     * Set BookingPartyID value
     * @param int $bookingPartyID
     * @return \StructType\GetPartiesRequest
     */
    public function setBookingPartyID($bookingPartyID = null)
    {
        // validation for constraint: int
        if (!is_null($bookingPartyID) && !is_numeric($bookingPartyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bookingPartyID)), __LINE__);
        }
        $this->BookingPartyID = $bookingPartyID;
        return $this;
    }
    /**
     * Get Field1 value
     * @return string|null
     */
    public function getField1()
    {
        return $this->Field1;
    }
    /**
     * Set Field1 value
     * @param string $field1
     * @return \StructType\GetPartiesRequest
     */
    public function setField1($field1 = null)
    {
        // validation for constraint: string
        if (!is_null($field1) && !is_string($field1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field1)), __LINE__);
        }
        $this->Field1 = $field1;
        return $this;
    }
    /**
     * Get Field2 value
     * @return string|null
     */
    public function getField2()
    {
        return $this->Field2;
    }
    /**
     * Set Field2 value
     * @param string $field2
     * @return \StructType\GetPartiesRequest
     */
    public function setField2($field2 = null)
    {
        // validation for constraint: string
        if (!is_null($field2) && !is_string($field2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field2)), __LINE__);
        }
        $this->Field2 = $field2;
        return $this;
    }
    /**
     * Get Field3 value
     * @return string|null
     */
    public function getField3()
    {
        return $this->Field3;
    }
    /**
     * Set Field3 value
     * @param string $field3
     * @return \StructType\GetPartiesRequest
     */
    public function setField3($field3 = null)
    {
        // validation for constraint: string
        if (!is_null($field3) && !is_string($field3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field3)), __LINE__);
        }
        $this->Field3 = $field3;
        return $this;
    }
    /**
     * Get Field4 value
     * @return string|null
     */
    public function getField4()
    {
        return $this->Field4;
    }
    /**
     * Set Field4 value
     * @param string $field4
     * @return \StructType\GetPartiesRequest
     */
    public function setField4($field4 = null)
    {
        // validation for constraint: string
        if (!is_null($field4) && !is_string($field4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field4)), __LINE__);
        }
        $this->Field4 = $field4;
        return $this;
    }
    /**
     * Get Field5 value
     * @return string|null
     */
    public function getField5()
    {
        return $this->Field5;
    }
    /**
     * Set Field5 value
     * @param string $field5
     * @return \StructType\GetPartiesRequest
     */
    public function setField5($field5 = null)
    {
        // validation for constraint: string
        if (!is_null($field5) && !is_string($field5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field5)), __LINE__);
        }
        $this->Field5 = $field5;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPartiesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
