<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetOrdersResponse StructType
 * @subpackage Structs
 */
class GetOrdersResponse extends ApiResponse
{
    /**
     * The RecordCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RecordCount;
    /**
     * The Orders
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOrderResponse
     */
    public $Orders;
    /**
     * Constructor method for GetOrdersResponse
     * @uses GetOrdersResponse::setRecordCount()
     * @uses GetOrdersResponse::setOrders()
     * @param int $recordCount
     * @param \ArrayType\ArrayOfOrderResponse $orders
     */
    public function __construct($recordCount = null, \ArrayType\ArrayOfOrderResponse $orders = null)
    {
        $this
            ->setRecordCount($recordCount)
            ->setOrders($orders);
    }
    /**
     * Get RecordCount value
     * @return int
     */
    public function getRecordCount()
    {
        return $this->RecordCount;
    }
    /**
     * Set RecordCount value
     * @param int $recordCount
     * @return \StructType\GetOrdersResponse
     */
    public function setRecordCount($recordCount = null)
    {
        // validation for constraint: int
        if (!is_null($recordCount) && !is_numeric($recordCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($recordCount)), __LINE__);
        }
        $this->RecordCount = $recordCount;
        return $this;
    }
    /**
     * Get Orders value
     * @return \ArrayType\ArrayOfOrderResponse|null
     */
    public function getOrders()
    {
        return $this->Orders;
    }
    /**
     * Set Orders value
     * @param \ArrayType\ArrayOfOrderResponse $orders
     * @return \StructType\GetOrdersResponse
     */
    public function setOrders(\ArrayType\ArrayOfOrderResponse $orders = null)
    {
        $this->Orders = $orders;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetOrdersResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
