<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetOrdersRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetOrdersRequest
 * @subpackage Structs
 */
class GetOrdersRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CustomerID;
    /**
     * The OrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $OrderID;
    /**
     * The OrderDateStart
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $OrderDateStart;
    /**
     * The OrderDateEnd
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $OrderDateEnd;
    /**
     * The OrderStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $OrderStatus;
    /**
     * The WarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $WarehouseID;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The ReturnCustomer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ReturnCustomer;
    /**
     * The ReturnKitDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ReturnKitDetails;
    /**
     * The GreaterThanOrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $GreaterThanOrderID;
    /**
     * The GreaterThanModifiedDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $GreaterThanModifiedDate;
    /**
     * The BatchSize
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BatchSize;
    /**
     * The PartyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PartyID;
    /**
     * The OrderIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $OrderIDs;
    /**
     * The Other11
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other11;
    /**
     * The Other12
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other12;
    /**
     * The Other13
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other13;
    /**
     * The Other14
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other14;
    /**
     * The Other15
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other15;
    /**
     * The Other16
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other16;
    /**
     * The Other17
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other17;
    /**
     * The Other18
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other18;
    /**
     * The Other19
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other19;
    /**
     * The Other20
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other20;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * The OrderKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderKey;
    /**
     * The OrderKeys
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $OrderKeys;
    /**
     * Constructor method for GetOrdersRequest
     * @uses GetOrdersRequest::setCustomerID()
     * @uses GetOrdersRequest::setOrderID()
     * @uses GetOrdersRequest::setOrderDateStart()
     * @uses GetOrdersRequest::setOrderDateEnd()
     * @uses GetOrdersRequest::setOrderStatus()
     * @uses GetOrdersRequest::setWarehouseID()
     * @uses GetOrdersRequest::setCurrencyCode()
     * @uses GetOrdersRequest::setReturnCustomer()
     * @uses GetOrdersRequest::setReturnKitDetails()
     * @uses GetOrdersRequest::setGreaterThanOrderID()
     * @uses GetOrdersRequest::setGreaterThanModifiedDate()
     * @uses GetOrdersRequest::setBatchSize()
     * @uses GetOrdersRequest::setPartyID()
     * @uses GetOrdersRequest::setOrderIDs()
     * @uses GetOrdersRequest::setOther11()
     * @uses GetOrdersRequest::setOther12()
     * @uses GetOrdersRequest::setOther13()
     * @uses GetOrdersRequest::setOther14()
     * @uses GetOrdersRequest::setOther15()
     * @uses GetOrdersRequest::setOther16()
     * @uses GetOrdersRequest::setOther17()
     * @uses GetOrdersRequest::setOther18()
     * @uses GetOrdersRequest::setOther19()
     * @uses GetOrdersRequest::setOther20()
     * @uses GetOrdersRequest::setCustomerKey()
     * @uses GetOrdersRequest::setOrderKey()
     * @uses GetOrdersRequest::setOrderKeys()
     * @param int $customerID
     * @param int $orderID
     * @param string $orderDateStart
     * @param string $orderDateEnd
     * @param string $orderStatus
     * @param int $warehouseID
     * @param string $currencyCode
     * @param bool $returnCustomer
     * @param bool $returnKitDetails
     * @param int $greaterThanOrderID
     * @param string $greaterThanModifiedDate
     * @param int $batchSize
     * @param int $partyID
     * @param \ArrayType\ArrayOfInt $orderIDs
     * @param string $other11
     * @param string $other12
     * @param string $other13
     * @param string $other14
     * @param string $other15
     * @param string $other16
     * @param string $other17
     * @param string $other18
     * @param string $other19
     * @param string $other20
     * @param string $customerKey
     * @param string $orderKey
     * @param \ArrayType\ArrayOfString $orderKeys
     */
    public function __construct($customerID = null, $orderID = null, $orderDateStart = null, $orderDateEnd = null, $orderStatus = null, $warehouseID = null, $currencyCode = null, $returnCustomer = null, $returnKitDetails = null, $greaterThanOrderID = null, $greaterThanModifiedDate = null, $batchSize = null, $partyID = null, \ArrayType\ArrayOfInt $orderIDs = null, $other11 = null, $other12 = null, $other13 = null, $other14 = null, $other15 = null, $other16 = null, $other17 = null, $other18 = null, $other19 = null, $other20 = null, $customerKey = null, $orderKey = null, \ArrayType\ArrayOfString $orderKeys = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setOrderID($orderID)
            ->setOrderDateStart($orderDateStart)
            ->setOrderDateEnd($orderDateEnd)
            ->setOrderStatus($orderStatus)
            ->setWarehouseID($warehouseID)
            ->setCurrencyCode($currencyCode)
            ->setReturnCustomer($returnCustomer)
            ->setReturnKitDetails($returnKitDetails)
            ->setGreaterThanOrderID($greaterThanOrderID)
            ->setGreaterThanModifiedDate($greaterThanModifiedDate)
            ->setBatchSize($batchSize)
            ->setPartyID($partyID)
            ->setOrderIDs($orderIDs)
            ->setOther11($other11)
            ->setOther12($other12)
            ->setOther13($other13)
            ->setOther14($other14)
            ->setOther15($other15)
            ->setOther16($other16)
            ->setOther17($other17)
            ->setOther18($other18)
            ->setOther19($other19)
            ->setOther20($other20)
            ->setCustomerKey($customerKey)
            ->setOrderKey($orderKey)
            ->setOrderKeys($orderKeys);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\GetOrdersRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get OrderID value
     * @return int
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param int $orderID
     * @return \StructType\GetOrdersRequest
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: int
        if (!is_null($orderID) && !is_numeric($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get OrderDateStart value
     * @return string
     */
    public function getOrderDateStart()
    {
        return $this->OrderDateStart;
    }
    /**
     * Set OrderDateStart value
     * @param string $orderDateStart
     * @return \StructType\GetOrdersRequest
     */
    public function setOrderDateStart($orderDateStart = null)
    {
        // validation for constraint: string
        if (!is_null($orderDateStart) && !is_string($orderDateStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderDateStart)), __LINE__);
        }
        $this->OrderDateStart = $orderDateStart;
        return $this;
    }
    /**
     * Get OrderDateEnd value
     * @return string
     */
    public function getOrderDateEnd()
    {
        return $this->OrderDateEnd;
    }
    /**
     * Set OrderDateEnd value
     * @param string $orderDateEnd
     * @return \StructType\GetOrdersRequest
     */
    public function setOrderDateEnd($orderDateEnd = null)
    {
        // validation for constraint: string
        if (!is_null($orderDateEnd) && !is_string($orderDateEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderDateEnd)), __LINE__);
        }
        $this->OrderDateEnd = $orderDateEnd;
        return $this;
    }
    /**
     * Get OrderStatus value
     * @return string
     */
    public function getOrderStatus()
    {
        return $this->OrderStatus;
    }
    /**
     * Set OrderStatus value
     * @uses \EnumType\OrderStatusType::valueIsValid()
     * @uses \EnumType\OrderStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderStatus
     * @return \StructType\GetOrdersRequest
     */
    public function setOrderStatus($orderStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OrderStatusType::valueIsValid($orderStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $orderStatus, implode(', ', \EnumType\OrderStatusType::getValidValues())), __LINE__);
        }
        $this->OrderStatus = $orderStatus;
        return $this;
    }
    /**
     * Get WarehouseID value
     * @return int
     */
    public function getWarehouseID()
    {
        return $this->WarehouseID;
    }
    /**
     * Set WarehouseID value
     * @param int $warehouseID
     * @return \StructType\GetOrdersRequest
     */
    public function setWarehouseID($warehouseID = null)
    {
        // validation for constraint: int
        if (!is_null($warehouseID) && !is_numeric($warehouseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($warehouseID)), __LINE__);
        }
        $this->WarehouseID = $warehouseID;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\GetOrdersRequest
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get ReturnCustomer value
     * @return bool
     */
    public function getReturnCustomer()
    {
        return $this->ReturnCustomer;
    }
    /**
     * Set ReturnCustomer value
     * @param bool $returnCustomer
     * @return \StructType\GetOrdersRequest
     */
    public function setReturnCustomer($returnCustomer = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnCustomer) && !is_bool($returnCustomer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($returnCustomer)), __LINE__);
        }
        $this->ReturnCustomer = $returnCustomer;
        return $this;
    }
    /**
     * Get ReturnKitDetails value
     * @return bool
     */
    public function getReturnKitDetails()
    {
        return $this->ReturnKitDetails;
    }
    /**
     * Set ReturnKitDetails value
     * @param bool $returnKitDetails
     * @return \StructType\GetOrdersRequest
     */
    public function setReturnKitDetails($returnKitDetails = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnKitDetails) && !is_bool($returnKitDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($returnKitDetails)), __LINE__);
        }
        $this->ReturnKitDetails = $returnKitDetails;
        return $this;
    }
    /**
     * Get GreaterThanOrderID value
     * @return int
     */
    public function getGreaterThanOrderID()
    {
        return $this->GreaterThanOrderID;
    }
    /**
     * Set GreaterThanOrderID value
     * @param int $greaterThanOrderID
     * @return \StructType\GetOrdersRequest
     */
    public function setGreaterThanOrderID($greaterThanOrderID = null)
    {
        // validation for constraint: int
        if (!is_null($greaterThanOrderID) && !is_numeric($greaterThanOrderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($greaterThanOrderID)), __LINE__);
        }
        $this->GreaterThanOrderID = $greaterThanOrderID;
        return $this;
    }
    /**
     * Get GreaterThanModifiedDate value
     * @return string
     */
    public function getGreaterThanModifiedDate()
    {
        return $this->GreaterThanModifiedDate;
    }
    /**
     * Set GreaterThanModifiedDate value
     * @param string $greaterThanModifiedDate
     * @return \StructType\GetOrdersRequest
     */
    public function setGreaterThanModifiedDate($greaterThanModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($greaterThanModifiedDate) && !is_string($greaterThanModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($greaterThanModifiedDate)), __LINE__);
        }
        $this->GreaterThanModifiedDate = $greaterThanModifiedDate;
        return $this;
    }
    /**
     * Get BatchSize value
     * @return int
     */
    public function getBatchSize()
    {
        return $this->BatchSize;
    }
    /**
     * Set BatchSize value
     * @param int $batchSize
     * @return \StructType\GetOrdersRequest
     */
    public function setBatchSize($batchSize = null)
    {
        // validation for constraint: int
        if (!is_null($batchSize) && !is_numeric($batchSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($batchSize)), __LINE__);
        }
        $this->BatchSize = $batchSize;
        return $this;
    }
    /**
     * Get PartyID value
     * @return int
     */
    public function getPartyID()
    {
        return $this->PartyID;
    }
    /**
     * Set PartyID value
     * @param int $partyID
     * @return \StructType\GetOrdersRequest
     */
    public function setPartyID($partyID = null)
    {
        // validation for constraint: int
        if (!is_null($partyID) && !is_numeric($partyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($partyID)), __LINE__);
        }
        $this->PartyID = $partyID;
        return $this;
    }
    /**
     * Get OrderIDs value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getOrderIDs()
    {
        return $this->OrderIDs;
    }
    /**
     * Set OrderIDs value
     * @param \ArrayType\ArrayOfInt $orderIDs
     * @return \StructType\GetOrdersRequest
     */
    public function setOrderIDs(\ArrayType\ArrayOfInt $orderIDs = null)
    {
        $this->OrderIDs = $orderIDs;
        return $this;
    }
    /**
     * Get Other11 value
     * @return string|null
     */
    public function getOther11()
    {
        return $this->Other11;
    }
    /**
     * Set Other11 value
     * @param string $other11
     * @return \StructType\GetOrdersRequest
     */
    public function setOther11($other11 = null)
    {
        // validation for constraint: string
        if (!is_null($other11) && !is_string($other11)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other11)), __LINE__);
        }
        $this->Other11 = $other11;
        return $this;
    }
    /**
     * Get Other12 value
     * @return string|null
     */
    public function getOther12()
    {
        return $this->Other12;
    }
    /**
     * Set Other12 value
     * @param string $other12
     * @return \StructType\GetOrdersRequest
     */
    public function setOther12($other12 = null)
    {
        // validation for constraint: string
        if (!is_null($other12) && !is_string($other12)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other12)), __LINE__);
        }
        $this->Other12 = $other12;
        return $this;
    }
    /**
     * Get Other13 value
     * @return string|null
     */
    public function getOther13()
    {
        return $this->Other13;
    }
    /**
     * Set Other13 value
     * @param string $other13
     * @return \StructType\GetOrdersRequest
     */
    public function setOther13($other13 = null)
    {
        // validation for constraint: string
        if (!is_null($other13) && !is_string($other13)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other13)), __LINE__);
        }
        $this->Other13 = $other13;
        return $this;
    }
    /**
     * Get Other14 value
     * @return string|null
     */
    public function getOther14()
    {
        return $this->Other14;
    }
    /**
     * Set Other14 value
     * @param string $other14
     * @return \StructType\GetOrdersRequest
     */
    public function setOther14($other14 = null)
    {
        // validation for constraint: string
        if (!is_null($other14) && !is_string($other14)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other14)), __LINE__);
        }
        $this->Other14 = $other14;
        return $this;
    }
    /**
     * Get Other15 value
     * @return string|null
     */
    public function getOther15()
    {
        return $this->Other15;
    }
    /**
     * Set Other15 value
     * @param string $other15
     * @return \StructType\GetOrdersRequest
     */
    public function setOther15($other15 = null)
    {
        // validation for constraint: string
        if (!is_null($other15) && !is_string($other15)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other15)), __LINE__);
        }
        $this->Other15 = $other15;
        return $this;
    }
    /**
     * Get Other16 value
     * @return string|null
     */
    public function getOther16()
    {
        return $this->Other16;
    }
    /**
     * Set Other16 value
     * @param string $other16
     * @return \StructType\GetOrdersRequest
     */
    public function setOther16($other16 = null)
    {
        // validation for constraint: string
        if (!is_null($other16) && !is_string($other16)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other16)), __LINE__);
        }
        $this->Other16 = $other16;
        return $this;
    }
    /**
     * Get Other17 value
     * @return string|null
     */
    public function getOther17()
    {
        return $this->Other17;
    }
    /**
     * Set Other17 value
     * @param string $other17
     * @return \StructType\GetOrdersRequest
     */
    public function setOther17($other17 = null)
    {
        // validation for constraint: string
        if (!is_null($other17) && !is_string($other17)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other17)), __LINE__);
        }
        $this->Other17 = $other17;
        return $this;
    }
    /**
     * Get Other18 value
     * @return string|null
     */
    public function getOther18()
    {
        return $this->Other18;
    }
    /**
     * Set Other18 value
     * @param string $other18
     * @return \StructType\GetOrdersRequest
     */
    public function setOther18($other18 = null)
    {
        // validation for constraint: string
        if (!is_null($other18) && !is_string($other18)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other18)), __LINE__);
        }
        $this->Other18 = $other18;
        return $this;
    }
    /**
     * Get Other19 value
     * @return string|null
     */
    public function getOther19()
    {
        return $this->Other19;
    }
    /**
     * Set Other19 value
     * @param string $other19
     * @return \StructType\GetOrdersRequest
     */
    public function setOther19($other19 = null)
    {
        // validation for constraint: string
        if (!is_null($other19) && !is_string($other19)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other19)), __LINE__);
        }
        $this->Other19 = $other19;
        return $this;
    }
    /**
     * Get Other20 value
     * @return string|null
     */
    public function getOther20()
    {
        return $this->Other20;
    }
    /**
     * Set Other20 value
     * @param string $other20
     * @return \StructType\GetOrdersRequest
     */
    public function setOther20($other20 = null)
    {
        // validation for constraint: string
        if (!is_null($other20) && !is_string($other20)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other20)), __LINE__);
        }
        $this->Other20 = $other20;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\GetOrdersRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Get OrderKey value
     * @return string|null
     */
    public function getOrderKey()
    {
        return $this->OrderKey;
    }
    /**
     * Set OrderKey value
     * @param string $orderKey
     * @return \StructType\GetOrdersRequest
     */
    public function setOrderKey($orderKey = null)
    {
        // validation for constraint: string
        if (!is_null($orderKey) && !is_string($orderKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderKey)), __LINE__);
        }
        $this->OrderKey = $orderKey;
        return $this;
    }
    /**
     * Get OrderKeys value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getOrderKeys()
    {
        return $this->OrderKeys;
    }
    /**
     * Set OrderKeys value
     * @param \ArrayType\ArrayOfString $orderKeys
     * @return \StructType\GetOrdersRequest
     */
    public function setOrderKeys(\ArrayType\ArrayOfString $orderKeys = null)
    {
        $this->OrderKeys = $orderKeys;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetOrdersRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
