<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetItemsRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetItemsRequest
 * @subpackage Structs
 */
class GetItemsRequest extends ApiRequest
{
    /**
     * The PriceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PriceType;
    /**
     * The WarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WarehouseID;
    /**
     * The WebID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $WebID;
    /**
     * The WebCategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $WebCategoryID;
    /**
     * The ReturnLongDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ReturnLongDetail;
    /**
     * The RestrictToWarehouse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $RestrictToWarehouse;
    /**
     * The LanguageID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $LanguageID;
    /**
     * The ExcludeHideFromSearch
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ExcludeHideFromSearch;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * The ItemCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $ItemCodes;
    /**
     * Constructor method for GetItemsRequest
     * @uses GetItemsRequest::setPriceType()
     * @uses GetItemsRequest::setWarehouseID()
     * @uses GetItemsRequest::setWebID()
     * @uses GetItemsRequest::setWebCategoryID()
     * @uses GetItemsRequest::setReturnLongDetail()
     * @uses GetItemsRequest::setRestrictToWarehouse()
     * @uses GetItemsRequest::setLanguageID()
     * @uses GetItemsRequest::setExcludeHideFromSearch()
     * @uses GetItemsRequest::setCurrencyCode()
     * @uses GetItemsRequest::setItemCodes()
     * @param int $priceType
     * @param int $warehouseID
     * @param int $webID
     * @param int $webCategoryID
     * @param bool $returnLongDetail
     * @param bool $restrictToWarehouse
     * @param int $languageID
     * @param bool $excludeHideFromSearch
     * @param string $currencyCode
     * @param \ArrayType\ArrayOfString $itemCodes
     */
    public function __construct($priceType = null, $warehouseID = null, $webID = null, $webCategoryID = null, $returnLongDetail = null, $restrictToWarehouse = null, $languageID = null, $excludeHideFromSearch = null, $currencyCode = null, \ArrayType\ArrayOfString $itemCodes = null)
    {
        $this
            ->setPriceType($priceType)
            ->setWarehouseID($warehouseID)
            ->setWebID($webID)
            ->setWebCategoryID($webCategoryID)
            ->setReturnLongDetail($returnLongDetail)
            ->setRestrictToWarehouse($restrictToWarehouse)
            ->setLanguageID($languageID)
            ->setExcludeHideFromSearch($excludeHideFromSearch)
            ->setCurrencyCode($currencyCode)
            ->setItemCodes($itemCodes);
    }
    /**
     * Get PriceType value
     * @return int
     */
    public function getPriceType()
    {
        return $this->PriceType;
    }
    /**
     * Set PriceType value
     * @param int $priceType
     * @return \StructType\GetItemsRequest
     */
    public function setPriceType($priceType = null)
    {
        // validation for constraint: int
        if (!is_null($priceType) && !is_numeric($priceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($priceType)), __LINE__);
        }
        $this->PriceType = $priceType;
        return $this;
    }
    /**
     * Get WarehouseID value
     * @return int
     */
    public function getWarehouseID()
    {
        return $this->WarehouseID;
    }
    /**
     * Set WarehouseID value
     * @param int $warehouseID
     * @return \StructType\GetItemsRequest
     */
    public function setWarehouseID($warehouseID = null)
    {
        // validation for constraint: int
        if (!is_null($warehouseID) && !is_numeric($warehouseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($warehouseID)), __LINE__);
        }
        $this->WarehouseID = $warehouseID;
        return $this;
    }
    /**
     * Get WebID value
     * @return int
     */
    public function getWebID()
    {
        return $this->WebID;
    }
    /**
     * Set WebID value
     * @param int $webID
     * @return \StructType\GetItemsRequest
     */
    public function setWebID($webID = null)
    {
        // validation for constraint: int
        if (!is_null($webID) && !is_numeric($webID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($webID)), __LINE__);
        }
        $this->WebID = $webID;
        return $this;
    }
    /**
     * Get WebCategoryID value
     * @return int
     */
    public function getWebCategoryID()
    {
        return $this->WebCategoryID;
    }
    /**
     * Set WebCategoryID value
     * @param int $webCategoryID
     * @return \StructType\GetItemsRequest
     */
    public function setWebCategoryID($webCategoryID = null)
    {
        // validation for constraint: int
        if (!is_null($webCategoryID) && !is_numeric($webCategoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($webCategoryID)), __LINE__);
        }
        $this->WebCategoryID = $webCategoryID;
        return $this;
    }
    /**
     * Get ReturnLongDetail value
     * @return bool
     */
    public function getReturnLongDetail()
    {
        return $this->ReturnLongDetail;
    }
    /**
     * Set ReturnLongDetail value
     * @param bool $returnLongDetail
     * @return \StructType\GetItemsRequest
     */
    public function setReturnLongDetail($returnLongDetail = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnLongDetail) && !is_bool($returnLongDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($returnLongDetail)), __LINE__);
        }
        $this->ReturnLongDetail = $returnLongDetail;
        return $this;
    }
    /**
     * Get RestrictToWarehouse value
     * @return bool
     */
    public function getRestrictToWarehouse()
    {
        return $this->RestrictToWarehouse;
    }
    /**
     * Set RestrictToWarehouse value
     * @param bool $restrictToWarehouse
     * @return \StructType\GetItemsRequest
     */
    public function setRestrictToWarehouse($restrictToWarehouse = null)
    {
        // validation for constraint: boolean
        if (!is_null($restrictToWarehouse) && !is_bool($restrictToWarehouse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($restrictToWarehouse)), __LINE__);
        }
        $this->RestrictToWarehouse = $restrictToWarehouse;
        return $this;
    }
    /**
     * Get LanguageID value
     * @return int
     */
    public function getLanguageID()
    {
        return $this->LanguageID;
    }
    /**
     * Set LanguageID value
     * @param int $languageID
     * @return \StructType\GetItemsRequest
     */
    public function setLanguageID($languageID = null)
    {
        // validation for constraint: int
        if (!is_null($languageID) && !is_numeric($languageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($languageID)), __LINE__);
        }
        $this->LanguageID = $languageID;
        return $this;
    }
    /**
     * Get ExcludeHideFromSearch value
     * @return bool
     */
    public function getExcludeHideFromSearch()
    {
        return $this->ExcludeHideFromSearch;
    }
    /**
     * Set ExcludeHideFromSearch value
     * @param bool $excludeHideFromSearch
     * @return \StructType\GetItemsRequest
     */
    public function setExcludeHideFromSearch($excludeHideFromSearch = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeHideFromSearch) && !is_bool($excludeHideFromSearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($excludeHideFromSearch)), __LINE__);
        }
        $this->ExcludeHideFromSearch = $excludeHideFromSearch;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\GetItemsRequest
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get ItemCodes value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getItemCodes()
    {
        return $this->ItemCodes;
    }
    /**
     * Set ItemCodes value
     * @param \ArrayType\ArrayOfString $itemCodes
     * @return \StructType\GetItemsRequest
     */
    public function setItemCodes(\ArrayType\ArrayOfString $itemCodes = null)
    {
        $this->ItemCodes = $itemCodes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetItemsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
