<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEntityRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetEntityRequest
 * @subpackage Structs
 */
class GetEntityRequest extends ApiRequest
{
    /**
     * The SchemaName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SchemaName;
    /**
     * The EntityName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EntityName;
    /**
     * Constructor method for GetEntityRequest
     * @uses GetEntityRequest::setSchemaName()
     * @uses GetEntityRequest::setEntityName()
     * @param string $schemaName
     * @param string $entityName
     */
    public function __construct($schemaName = null, $entityName = null)
    {
        $this
            ->setSchemaName($schemaName)
            ->setEntityName($entityName);
    }
    /**
     * Get SchemaName value
     * @return string|null
     */
    public function getSchemaName()
    {
        return $this->SchemaName;
    }
    /**
     * Set SchemaName value
     * @param string $schemaName
     * @return \StructType\GetEntityRequest
     */
    public function setSchemaName($schemaName = null)
    {
        // validation for constraint: string
        if (!is_null($schemaName) && !is_string($schemaName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schemaName)), __LINE__);
        }
        $this->SchemaName = $schemaName;
        return $this;
    }
    /**
     * Get EntityName value
     * @return string|null
     */
    public function getEntityName()
    {
        return $this->EntityName;
    }
    /**
     * Set EntityName value
     * @param string $entityName
     * @return \StructType\GetEntityRequest
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entityName)), __LINE__);
        }
        $this->EntityName = $entityName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetEntityRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
