<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEmailAttachmentRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetEmailAttachmentRequest
 * @subpackage Structs
 */
class GetEmailAttachmentRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The MailID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MailID;
    /**
     * The AttachmentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AttachmentID;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for GetEmailAttachmentRequest
     * @uses GetEmailAttachmentRequest::setCustomerID()
     * @uses GetEmailAttachmentRequest::setMailID()
     * @uses GetEmailAttachmentRequest::setAttachmentID()
     * @uses GetEmailAttachmentRequest::setCustomerKey()
     * @param int $customerID
     * @param int $mailID
     * @param int $attachmentID
     * @param string $customerKey
     */
    public function __construct($customerID = null, $mailID = null, $attachmentID = null, $customerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setMailID($mailID)
            ->setAttachmentID($attachmentID)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\GetEmailAttachmentRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get MailID value
     * @return int
     */
    public function getMailID()
    {
        return $this->MailID;
    }
    /**
     * Set MailID value
     * @param int $mailID
     * @return \StructType\GetEmailAttachmentRequest
     */
    public function setMailID($mailID = null)
    {
        // validation for constraint: int
        if (!is_null($mailID) && !is_numeric($mailID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($mailID)), __LINE__);
        }
        $this->MailID = $mailID;
        return $this;
    }
    /**
     * Get AttachmentID value
     * @return int
     */
    public function getAttachmentID()
    {
        return $this->AttachmentID;
    }
    /**
     * Set AttachmentID value
     * @param int $attachmentID
     * @return \StructType\GetEmailAttachmentRequest
     */
    public function setAttachmentID($attachmentID = null)
    {
        // validation for constraint: int
        if (!is_null($attachmentID) && !is_numeric($attachmentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($attachmentID)), __LINE__);
        }
        $this->AttachmentID = $attachmentID;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\GetEmailAttachmentRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetEmailAttachmentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
