<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDownlineRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetDownlineRequest
 * @subpackage Structs
 */
class GetDownlineRequest extends ApiRequest
{
    /**
     * The TreeType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TreeType;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The PeriodType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PeriodType;
    /**
     * The PeriodID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PeriodID;
    /**
     * The MaxLevelDepth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaxLevelDepth;
    /**
     * The BatchSize
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BatchSize;
    /**
     * The SortByLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SortByLevel;
    /**
     * The BatchOffset
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BatchOffset;
    /**
     * The CustomerTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $CustomerTypes;
    /**
     * The Ranks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $Ranks;
    /**
     * The PayRanks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $PayRanks;
    /**
     * The VolumeFilters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfVolumeFilter
     */
    public $VolumeFilters;
    /**
     * The CustomerStatusTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $CustomerStatusTypes;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for GetDownlineRequest
     * @uses GetDownlineRequest::setTreeType()
     * @uses GetDownlineRequest::setCustomerID()
     * @uses GetDownlineRequest::setPeriodType()
     * @uses GetDownlineRequest::setPeriodID()
     * @uses GetDownlineRequest::setMaxLevelDepth()
     * @uses GetDownlineRequest::setBatchSize()
     * @uses GetDownlineRequest::setSortByLevel()
     * @uses GetDownlineRequest::setBatchOffset()
     * @uses GetDownlineRequest::setCustomerTypes()
     * @uses GetDownlineRequest::setRanks()
     * @uses GetDownlineRequest::setPayRanks()
     * @uses GetDownlineRequest::setVolumeFilters()
     * @uses GetDownlineRequest::setCustomerStatusTypes()
     * @uses GetDownlineRequest::setCustomerKey()
     * @param string $treeType
     * @param int $customerID
     * @param int $periodType
     * @param int $periodID
     * @param int $maxLevelDepth
     * @param int $batchSize
     * @param bool $sortByLevel
     * @param int $batchOffset
     * @param \ArrayType\ArrayOfInt $customerTypes
     * @param \ArrayType\ArrayOfInt $ranks
     * @param \ArrayType\ArrayOfInt $payRanks
     * @param \ArrayType\ArrayOfVolumeFilter $volumeFilters
     * @param \ArrayType\ArrayOfInt $customerStatusTypes
     * @param string $customerKey
     */
    public function __construct($treeType = null, $customerID = null, $periodType = null, $periodID = null, $maxLevelDepth = null, $batchSize = null, $sortByLevel = null, $batchOffset = null, \ArrayType\ArrayOfInt $customerTypes = null, \ArrayType\ArrayOfInt $ranks = null, \ArrayType\ArrayOfInt $payRanks = null, \ArrayType\ArrayOfVolumeFilter $volumeFilters = null, \ArrayType\ArrayOfInt $customerStatusTypes = null, $customerKey = null)
    {
        $this
            ->setTreeType($treeType)
            ->setCustomerID($customerID)
            ->setPeriodType($periodType)
            ->setPeriodID($periodID)
            ->setMaxLevelDepth($maxLevelDepth)
            ->setBatchSize($batchSize)
            ->setSortByLevel($sortByLevel)
            ->setBatchOffset($batchOffset)
            ->setCustomerTypes($customerTypes)
            ->setRanks($ranks)
            ->setPayRanks($payRanks)
            ->setVolumeFilters($volumeFilters)
            ->setCustomerStatusTypes($customerStatusTypes)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get TreeType value
     * @return string
     */
    public function getTreeType()
    {
        return $this->TreeType;
    }
    /**
     * Set TreeType value
     * @uses \EnumType\TreeType::valueIsValid()
     * @uses \EnumType\TreeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $treeType
     * @return \StructType\GetDownlineRequest
     */
    public function setTreeType($treeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TreeType::valueIsValid($treeType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $treeType, implode(', ', \EnumType\TreeType::getValidValues())), __LINE__);
        }
        $this->TreeType = $treeType;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\GetDownlineRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get PeriodType value
     * @return int
     */
    public function getPeriodType()
    {
        return $this->PeriodType;
    }
    /**
     * Set PeriodType value
     * @param int $periodType
     * @return \StructType\GetDownlineRequest
     */
    public function setPeriodType($periodType = null)
    {
        // validation for constraint: int
        if (!is_null($periodType) && !is_numeric($periodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($periodType)), __LINE__);
        }
        $this->PeriodType = $periodType;
        return $this;
    }
    /**
     * Get PeriodID value
     * @return int
     */
    public function getPeriodID()
    {
        return $this->PeriodID;
    }
    /**
     * Set PeriodID value
     * @param int $periodID
     * @return \StructType\GetDownlineRequest
     */
    public function setPeriodID($periodID = null)
    {
        // validation for constraint: int
        if (!is_null($periodID) && !is_numeric($periodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($periodID)), __LINE__);
        }
        $this->PeriodID = $periodID;
        return $this;
    }
    /**
     * Get MaxLevelDepth value
     * @return int
     */
    public function getMaxLevelDepth()
    {
        return $this->MaxLevelDepth;
    }
    /**
     * Set MaxLevelDepth value
     * @param int $maxLevelDepth
     * @return \StructType\GetDownlineRequest
     */
    public function setMaxLevelDepth($maxLevelDepth = null)
    {
        // validation for constraint: int
        if (!is_null($maxLevelDepth) && !is_numeric($maxLevelDepth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxLevelDepth)), __LINE__);
        }
        $this->MaxLevelDepth = $maxLevelDepth;
        return $this;
    }
    /**
     * Get BatchSize value
     * @return int
     */
    public function getBatchSize()
    {
        return $this->BatchSize;
    }
    /**
     * Set BatchSize value
     * @param int $batchSize
     * @return \StructType\GetDownlineRequest
     */
    public function setBatchSize($batchSize = null)
    {
        // validation for constraint: int
        if (!is_null($batchSize) && !is_numeric($batchSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($batchSize)), __LINE__);
        }
        $this->BatchSize = $batchSize;
        return $this;
    }
    /**
     * Get SortByLevel value
     * @return bool
     */
    public function getSortByLevel()
    {
        return $this->SortByLevel;
    }
    /**
     * Set SortByLevel value
     * @param bool $sortByLevel
     * @return \StructType\GetDownlineRequest
     */
    public function setSortByLevel($sortByLevel = null)
    {
        // validation for constraint: boolean
        if (!is_null($sortByLevel) && !is_bool($sortByLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sortByLevel)), __LINE__);
        }
        $this->SortByLevel = $sortByLevel;
        return $this;
    }
    /**
     * Get BatchOffset value
     * @return int
     */
    public function getBatchOffset()
    {
        return $this->BatchOffset;
    }
    /**
     * Set BatchOffset value
     * @param int $batchOffset
     * @return \StructType\GetDownlineRequest
     */
    public function setBatchOffset($batchOffset = null)
    {
        // validation for constraint: int
        if (!is_null($batchOffset) && !is_numeric($batchOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($batchOffset)), __LINE__);
        }
        $this->BatchOffset = $batchOffset;
        return $this;
    }
    /**
     * Get CustomerTypes value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getCustomerTypes()
    {
        return $this->CustomerTypes;
    }
    /**
     * Set CustomerTypes value
     * @param \ArrayType\ArrayOfInt $customerTypes
     * @return \StructType\GetDownlineRequest
     */
    public function setCustomerTypes(\ArrayType\ArrayOfInt $customerTypes = null)
    {
        $this->CustomerTypes = $customerTypes;
        return $this;
    }
    /**
     * Get Ranks value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getRanks()
    {
        return $this->Ranks;
    }
    /**
     * Set Ranks value
     * @param \ArrayType\ArrayOfInt $ranks
     * @return \StructType\GetDownlineRequest
     */
    public function setRanks(\ArrayType\ArrayOfInt $ranks = null)
    {
        $this->Ranks = $ranks;
        return $this;
    }
    /**
     * Get PayRanks value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getPayRanks()
    {
        return $this->PayRanks;
    }
    /**
     * Set PayRanks value
     * @param \ArrayType\ArrayOfInt $payRanks
     * @return \StructType\GetDownlineRequest
     */
    public function setPayRanks(\ArrayType\ArrayOfInt $payRanks = null)
    {
        $this->PayRanks = $payRanks;
        return $this;
    }
    /**
     * Get VolumeFilters value
     * @return \ArrayType\ArrayOfVolumeFilter|null
     */
    public function getVolumeFilters()
    {
        return $this->VolumeFilters;
    }
    /**
     * Set VolumeFilters value
     * @param \ArrayType\ArrayOfVolumeFilter $volumeFilters
     * @return \StructType\GetDownlineRequest
     */
    public function setVolumeFilters(\ArrayType\ArrayOfVolumeFilter $volumeFilters = null)
    {
        $this->VolumeFilters = $volumeFilters;
        return $this;
    }
    /**
     * Get CustomerStatusTypes value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getCustomerStatusTypes()
    {
        return $this->CustomerStatusTypes;
    }
    /**
     * Set CustomerStatusTypes value
     * @param \ArrayType\ArrayOfInt $customerStatusTypes
     * @return \StructType\GetDownlineRequest
     */
    public function setCustomerStatusTypes(\ArrayType\ArrayOfInt $customerStatusTypes = null)
    {
        $this->CustomerStatusTypes = $customerStatusTypes;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\GetDownlineRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDownlineRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
