<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomersResponse StructType
 * @subpackage Structs
 */
class GetCustomersResponse extends ApiResponse
{
    /**
     * The RecordCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RecordCount;
    /**
     * The Customers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCustomerResponse
     */
    public $Customers;
    /**
     * Constructor method for GetCustomersResponse
     * @uses GetCustomersResponse::setRecordCount()
     * @uses GetCustomersResponse::setCustomers()
     * @param int $recordCount
     * @param \ArrayType\ArrayOfCustomerResponse $customers
     */
    public function __construct($recordCount = null, \ArrayType\ArrayOfCustomerResponse $customers = null)
    {
        $this
            ->setRecordCount($recordCount)
            ->setCustomers($customers);
    }
    /**
     * Get RecordCount value
     * @return int
     */
    public function getRecordCount()
    {
        return $this->RecordCount;
    }
    /**
     * Set RecordCount value
     * @param int $recordCount
     * @return \StructType\GetCustomersResponse
     */
    public function setRecordCount($recordCount = null)
    {
        // validation for constraint: int
        if (!is_null($recordCount) && !is_numeric($recordCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($recordCount)), __LINE__);
        }
        $this->RecordCount = $recordCount;
        return $this;
    }
    /**
     * Get Customers value
     * @return \ArrayType\ArrayOfCustomerResponse|null
     */
    public function getCustomers()
    {
        return $this->Customers;
    }
    /**
     * Set Customers value
     * @param \ArrayType\ArrayOfCustomerResponse $customers
     * @return \StructType\GetCustomersResponse
     */
    public function setCustomers(\ArrayType\ArrayOfCustomerResponse $customers = null)
    {
        $this->Customers = $customers;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCustomersResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
