<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomerWallRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetCustomerWallRequest
 * @subpackage Structs
 */
class GetCustomerWallRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The WallItemID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $WallItemID;
    /**
     * The OlderThanEntryDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $OlderThanEntryDate;
    /**
     * The BatchSize
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BatchSize;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for GetCustomerWallRequest
     * @uses GetCustomerWallRequest::setCustomerID()
     * @uses GetCustomerWallRequest::setWallItemID()
     * @uses GetCustomerWallRequest::setOlderThanEntryDate()
     * @uses GetCustomerWallRequest::setBatchSize()
     * @uses GetCustomerWallRequest::setCustomerKey()
     * @param int $customerID
     * @param int $wallItemID
     * @param string $olderThanEntryDate
     * @param int $batchSize
     * @param string $customerKey
     */
    public function __construct($customerID = null, $wallItemID = null, $olderThanEntryDate = null, $batchSize = null, $customerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setWallItemID($wallItemID)
            ->setOlderThanEntryDate($olderThanEntryDate)
            ->setBatchSize($batchSize)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\GetCustomerWallRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get WallItemID value
     * @return int
     */
    public function getWallItemID()
    {
        return $this->WallItemID;
    }
    /**
     * Set WallItemID value
     * @param int $wallItemID
     * @return \StructType\GetCustomerWallRequest
     */
    public function setWallItemID($wallItemID = null)
    {
        // validation for constraint: int
        if (!is_null($wallItemID) && !is_numeric($wallItemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($wallItemID)), __LINE__);
        }
        $this->WallItemID = $wallItemID;
        return $this;
    }
    /**
     * Get OlderThanEntryDate value
     * @return string
     */
    public function getOlderThanEntryDate()
    {
        return $this->OlderThanEntryDate;
    }
    /**
     * Set OlderThanEntryDate value
     * @param string $olderThanEntryDate
     * @return \StructType\GetCustomerWallRequest
     */
    public function setOlderThanEntryDate($olderThanEntryDate = null)
    {
        // validation for constraint: string
        if (!is_null($olderThanEntryDate) && !is_string($olderThanEntryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($olderThanEntryDate)), __LINE__);
        }
        $this->OlderThanEntryDate = $olderThanEntryDate;
        return $this;
    }
    /**
     * Get BatchSize value
     * @return int
     */
    public function getBatchSize()
    {
        return $this->BatchSize;
    }
    /**
     * Set BatchSize value
     * @param int $batchSize
     * @return \StructType\GetCustomerWallRequest
     */
    public function setBatchSize($batchSize = null)
    {
        // validation for constraint: int
        if (!is_null($batchSize) && !is_numeric($batchSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($batchSize)), __LINE__);
        }
        $this->BatchSize = $batchSize;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\GetCustomerWallRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCustomerWallRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
